/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.agorava.api.atinject.BeanResolver;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.model.LinkedInProfile;
import org.agorava.linkedin.model.Post;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PostMixin
extends LinkedInObjectMixin {
    @JsonProperty
    Date creationTimestamp;
    @JsonProperty
    Post.PostRelation relationToViewer;
    @JsonProperty
    String summary;
    @JsonProperty
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;

    @JsonCreator
    PostMixin(@JsonProperty(value="creator") LinkedInProfile creator, @JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonProperty(value="type") @JsonDeserialize(using=PostTypeDeserializer.class) Post.PostType type) {
    }

    private static final class LikesListDeserializer
    extends JsonDeserializer<List<LinkedInProfile>> {
        private LikesListDeserializer() {
        }

        public List<LinkedInProfile> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = (ObjectMapper)BeanResolver.getInstance().resolve(ObjectMapper.class);
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<LinkedInProfile> likes = new ArrayList<LinkedInProfile>();
            if (jp.hasCurrentToken() && (dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values")) != null) {
                for (JsonNode d : dataNode) {
                    LinkedInProfile p = (LinkedInProfile)mapper.reader((TypeReference)new TypeReference<LinkedInProfile>(){}).readValue(d.path("person"));
                    likes.add(p);
                }
            }
            return likes;
        }
    }

    private static final class PostTypeDeserializer
    extends JsonDeserializer<Post.PostType> {
        private PostTypeDeserializer() {
        }

        public Post.PostType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            return Post.PostType.valueOf((String)node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }
}

