/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.agorava.linkedin.jackson.ConnectionAuthorizationDeserializer;
import org.agorava.linkedin.jackson.DeserializationUtils;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.jackson.RecommendationsListDeserializer;
import org.agorava.linkedin.model.ConnectionAuthorization;
import org.agorava.linkedin.model.CurrentShare;
import org.agorava.linkedin.model.Education;
import org.agorava.linkedin.model.ImAccount;
import org.agorava.linkedin.model.LinkedInDate;
import org.agorava.linkedin.model.Location;
import org.agorava.linkedin.model.PhoneNumber;
import org.agorava.linkedin.model.Position;
import org.agorava.linkedin.model.Recommendation;
import org.agorava.linkedin.model.Relation;
import org.agorava.linkedin.model.TwitterAccount;
import org.agorava.linkedin.model.UrlResource;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class LinkedInProfileFullMixin
extends LinkedInObjectMixin {
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> positions;
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> threeCurrentPositions;
    @JsonProperty
    @JsonDeserialize(using=PositionListDeserializer.class)
    List<Position> threePastPositions;
    @JsonProperty
    @JsonDeserialize(using=RecommendationsListDeserializer.class)
    List<Recommendation> recommendationsReceived;
    @JsonProperty
    @JsonDeserialize(using=ImAccountListDeserializer.class)
    List<ImAccount> imAccounts;
    @JsonProperty
    @JsonDeserialize(using=TwitterAccountListDeserializer.class)
    List<TwitterAccount> twitterAccounts;
    @JsonProperty
    @JsonDeserialize(using=UrlResourceListDeserializer.class)
    List<UrlResource> memberUrlResources;
    @JsonProperty
    @JsonDeserialize(using=PhoneNumberListDeserializer.class)
    List<PhoneNumber> phoneNumbers;
    @JsonProperty
    @JsonDeserialize(using=SkillListDeserializer.class)
    List<String> skills;
    @JsonProperty
    @JsonDeserialize(using=EducationListDeserializer.class)
    List<Education> educations;
    @JsonProperty(value="summary")
    String summary;
    @JsonProperty
    String proposalComments;
    @JsonProperty
    String specialties;
    @JsonProperty
    int numConnections;
    @JsonProperty
    boolean numConnectionsCapped;
    @JsonProperty
    int numRecommenders;
    @JsonProperty
    String mainAddress;
    @JsonProperty
    String associations;
    @JsonProperty
    Location location;
    @JsonProperty
    String interests;
    @JsonProperty
    String honors;
    @JsonProperty
    int distance;
    @JsonProperty
    LinkedInDate dateOfBirth;
    @JsonProperty
    CurrentShare currentShare;
    @JsonProperty
    Relation relationToViewer;
    @JsonProperty(value="apiStandardProfileRequest")
    @JsonDeserialize(using=ConnectionAuthorizationDeserializer.class)
    ConnectionAuthorization connectionAuthorization;

    @JsonCreator
    LinkedInProfileFullMixin(@JsonProperty(value="id") String id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="headline") String headline, @JsonProperty(value="industry") String industry, @JsonProperty(value="publicProfileUrl") String publicProfileUrl, @JsonProperty(value="siteStandardProfileRequest") UrlResource siteStandardProfileRequest, @JsonProperty(value="pictureUrl") String profilePictureUrl) {
    }

    private static final class SkillListDeserializer
    extends JsonDeserializer<List<String>> {
        private SkillListDeserializer() {
        }

        public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                JsonNode dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values");
                ArrayList<String> skills = new ArrayList<String>();
                if (dataNode != null) {
                    for (JsonNode d : dataNode) {
                        String s = d.path("skill").path("name").textValue();
                        if (s == null) continue;
                        skills.add(s);
                    }
                }
                return skills;
            }
            throw ctxt.mappingException("Expected JSON object");
        }
    }

    private static final class EducationListDeserializer
    extends JsonDeserializer<List<Education>> {
        private EducationListDeserializer() {
        }

        public List<Education> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<Education>>(){});
        }
    }

    private static final class PhoneNumberListDeserializer
    extends JsonDeserializer<List<PhoneNumber>> {
        private PhoneNumberListDeserializer() {
        }

        public List<PhoneNumber> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<PhoneNumber>>(){});
        }
    }

    private static final class UrlResourceListDeserializer
    extends JsonDeserializer<List<UrlResource>> {
        private UrlResourceListDeserializer() {
        }

        public List<UrlResource> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<UrlResource>>(){});
        }
    }

    private static final class TwitterAccountListDeserializer
    extends JsonDeserializer<List<TwitterAccount>> {
        private TwitterAccountListDeserializer() {
        }

        public List<TwitterAccount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<TwitterAccount>>(){});
        }
    }

    private static final class ImAccountListDeserializer
    extends JsonDeserializer<List<ImAccount>> {
        private ImAccountListDeserializer() {
        }

        public List<ImAccount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<ImAccount>>(){});
        }
    }

    private static final class PositionListDeserializer
    extends JsonDeserializer<List<Position>> {
        private PositionListDeserializer() {
        }

        public List<Position> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<Position>>(){});
        }
    }
}

