/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.agorava.api.atinject.BeanResolver;
import org.agorava.linkedin.jackson.LikesListDeserializer;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.jackson.UpdateTypeDeserializer;
import org.agorava.linkedin.model.LinkedInProfile;
import org.agorava.linkedin.model.UpdateType;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class LinkedInNetworkUpdateMixin
extends LinkedInObjectMixin {
    @JsonProperty(value="isCommentable")
    boolean commentable;
    @JsonProperty(value="isLikable")
    boolean likeable;
    @JsonProperty(value="isLiked")
    boolean liked;
    @JsonProperty(value="numLikes")
    int numLikes;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;
    @JsonProperty(value="updatedFields")
    @JsonDeserialize(using=UpdatedFieldsListDeserializer.class)
    List<String> updatedFields;

    @JsonCreator
    LinkedInNetworkUpdateMixin(@JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="updateKey") String updateKey, @JsonProperty(value="updateType") @JsonDeserialize(using=UpdateTypeDeserializer.class) UpdateType updateType) {
    }

    private static class UpdatedFieldsListDeserializer
    extends JsonDeserializer<List<String>> {
        private UpdatedFieldsListDeserializer() {
        }

        public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = (ObjectMapper)BeanResolver.getInstance().resolve(ObjectMapper.class);
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken()) {
                JsonNode dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values");
                ArrayList<String> values = new ArrayList<String>();
                for (JsonNode value : dataNode) {
                    values.add(value.get("name").textValue());
                }
                return values;
            }
            return null;
        }
    }
}

