/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import org.agorava.linkedin.jackson.DeserializationUtils;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.model.CodeAndName;
import org.agorava.linkedin.model.Location;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class JobPositionMixin
extends LinkedInObjectMixin {
    @JsonProperty
    CodeAndName experienceLevel;
    @JsonProperty
    @JsonDeserialize(using=CodeAndNameListDeserializer.class)
    List<CodeAndName> industries;
    @JsonProperty
    @JsonDeserialize(using=CodeAndNameListDeserializer.class)
    List<CodeAndName> jobFunctions;
    @JsonProperty
    CodeAndName jobType;

    @JsonCreator
    JobPositionMixin(@JsonProperty(value="title") String title, @JsonProperty(value="location") Location location) {
    }

    private static final class CodeAndNameListDeserializer
    extends JsonDeserializer<List<CodeAndName>> {
        private CodeAndNameListDeserializer() {
        }

        public List<CodeAndName> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<CodeAndName>>(){});
        }
    }
}

