/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.model.Group;
import org.agorava.linkedin.model.GroupSettings;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupSettingsMixin
extends LinkedInObjectMixin {
    @JsonCreator
    GroupSettingsMixin(@JsonProperty(value="allowMessagesFromMembers") Boolean allowMessagesFromMembers, @JsonProperty(value="emailAnnouncementsFromManagers") Boolean emailAnnouncementsFromManagers, @JsonProperty(value="emailDigestFrequency") @JsonDeserialize(using=EmailDigestFrequencyDeserializer.class) GroupSettings.EmailDigestFrequency emailDigestFrequency, @JsonProperty(value="emailForEveryNewPost") Boolean emailForEveryNewPost, @JsonProperty(value="group") Group group, @JsonProperty(value="membershipState") @JsonDeserialize(using=MembershipStateDeserializer.class) Group.MembershipState membershipState, @JsonProperty(value="showGroupLogoInProfile") Boolean showGroupLogoInProfile) {
    }

    private static final class MembershipStateDeserializer
    extends JsonDeserializer<Group.MembershipState> {
        private MembershipStateDeserializer() {
        }

        public Group.MembershipState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            return Group.MembershipState.valueOf((String)node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }

    private static final class EmailDigestFrequencyDeserializer
    extends JsonDeserializer<GroupSettings.EmailDigestFrequency> {
        private EmailDigestFrequencyDeserializer() {
        }

        public GroupSettings.EmailDigestFrequency deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            return GroupSettings.EmailDigestFrequency.valueOf((String)node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }
}

