/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.agorava.api.atinject.BeanResolver;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.model.Group;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupRelationMixin
extends LinkedInObjectMixin {
    @JsonCreator
    GroupRelationMixin(@JsonProperty(value="availableActions") @JsonDeserialize(using=AvailableActionDeserializer.class) List<Group.GroupAvailableAction> availableActions, @JsonProperty(value="membershipState") @JsonDeserialize(using=MembershipStateDeserializer.class) Group.MembershipState membershipState) {
    }

    private static final class MembershipStateDeserializer
    extends JsonDeserializer<Group.MembershipState> {
        private MembershipStateDeserializer() {
        }

        public Group.MembershipState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            return Group.MembershipState.valueOf((String)node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }

    private static final class AvailableActionDeserializer
    extends JsonDeserializer<List<Group.GroupAvailableAction>> {
        private AvailableActionDeserializer() {
        }

        public List<Group.GroupAvailableAction> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = (ObjectMapper)BeanResolver.getInstance().resolve(ObjectMapper.class);
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<Group.GroupAvailableAction> actions = new ArrayList<Group.GroupAvailableAction>();
            if (jp.hasCurrentToken() && (dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values")) != null) {
                for (JsonNode d : dataNode) {
                    String s = d.path("code").textValue();
                    if (s == null) continue;
                    actions.add(Group.GroupAvailableAction.valueOf((String)s.replace('-', '_').toUpperCase()));
                }
            }
            return actions;
        }
    }
}

