/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import org.agorava.linkedin.jackson.DeserializationUtils;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.model.Group;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupMixin
extends LinkedInObjectMixin {
    @JsonProperty
    Boolean allowMemberInvites;
    @JsonProperty
    @JsonDeserialize(using=GroupCategoryDeserializer.class)
    Group.GroupCategory category;
    @JsonProperty
    @JsonDeserialize(using=GroupCountDeserializer.class)
    List<Group.GroupCount> countsByCategory;
    @JsonProperty
    String description;
    @JsonProperty
    Boolean isOpenToNonMembers;
    @JsonProperty
    String largeLogoUrl;
    @JsonProperty
    String locale;
    @JsonProperty
    Group.GroupPosts posts;
    @JsonProperty
    Group.GroupRelation relationToViewer;
    @JsonProperty
    String shortDescription;
    @JsonProperty
    String siteGroupUrl;
    @JsonProperty
    String smallLogoUrl;
    @JsonProperty
    String websiteUrl;

    @JsonCreator
    GroupMixin(@JsonProperty(value="id") Integer id, @JsonProperty(value="name") String name) {
    }

    private static final class GroupCountDeserializer
    extends JsonDeserializer<List<Group.GroupCount>> {
        private GroupCountDeserializer() {
        }

        public List<Group.GroupCount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<Group.GroupCount>>(){});
        }
    }

    private static final class GroupCategoryDeserializer
    extends JsonDeserializer<Group.GroupCategory> {
        private GroupCategoryDeserializer() {
        }

        public Group.GroupCategory deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            return Group.GroupCategory.valueOf((String)node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }
}

