/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.model.Post;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupCountMixin
extends LinkedInObjectMixin {
    @JsonCreator
    GroupCountMixin(@JsonProperty(value="category") @JsonDeserialize(using=PostCategoryDeserializer.class) Post.PostCategory category, @JsonProperty(value="count") Integer count) {
    }

    private static final class PostCategoryDeserializer
    extends JsonDeserializer<Post.PostCategory> {
        private PostCategoryDeserializer() {
        }

        public Post.PostCategory deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            return Post.PostCategory.valueOf((String)node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }
}

