/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.agorava.linkedin.jackson.LinkedInModule;

public class DeserializationUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T deserializeFromDataNode(JsonParser jp, DeserializationContext ctxt, String propertyName, TypeReference<T> typeReference) throws IOException, JsonProcessingException {
        if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
            JsonNode dataNode = (JsonNode)jp.readValueAs(JsonNode.class);
            if (dataNode.has(propertyName)) {
                return (T)OBJECT_MAPPER.reader(typeReference).readValue(dataNode.get(propertyName));
            }
            return null;
        }
        throw ctxt.mappingException("Expected JSON object");
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new LinkedInModule());
    }
}

