/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import org.agorava.LinkedInBaseService;
import org.agorava.linkedin.LinkedIn;
import org.agorava.linkedin.NetworkUpdateService;
import org.agorava.linkedin.model.Comment;
import org.agorava.linkedin.model.Comments;
import org.agorava.linkedin.model.CurrentShare;
import org.agorava.linkedin.model.Likes;
import org.agorava.linkedin.model.LinkedInNetworkUpdate;
import org.agorava.linkedin.model.LinkedInNetworkUpdates;
import org.agorava.linkedin.model.LinkedInProfile;
import org.agorava.linkedin.model.NetworkUpdateParameters;
import org.agorava.linkedin.model.NewShare;
import org.agorava.linkedin.model.UpdateContentShare;
import org.agorava.linkedin.model.UpdateTypeInput;

@Named
@LinkedIn
public class NetworkUpdateServiceImpl
extends LinkedInBaseService
implements NetworkUpdateService {
    static final String UPDATES_URL;
    static final String UPDATE_COMMENTS_URL;
    static final String UPDATE_LIKES_URL;
    static final String UPDATE_IS_LIKED_URL;
    static final String ACTIVITY_URL;
    static final String CURRENT_SHARE_URL;
    static final String SHARE_URL;
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_COUNT = 10;
    private static final String UPDATE_TYPE_ALL_STRING;

    public List<LinkedInNetworkUpdate> getNetworkUpdates() {
        NetworkUpdateParameters parameters = new NetworkUpdateParameters(null, false, 0, 10, null, null, true, false, Collections.emptyList());
        return this.getNetworkUpdates(parameters);
    }

    public List<LinkedInNetworkUpdate> getNetworkUpdates(int start, int count) {
        NetworkUpdateParameters parameters = new NetworkUpdateParameters(null, false, start, count, null, null, true, false, Collections.emptyList());
        return this.getNetworkUpdates(parameters);
    }

    public List<LinkedInNetworkUpdate> getNetworkUpdates(NetworkUpdateParameters parameters) {
        return this.getNetworkUpdates(parameters, LinkedInNetworkUpdates.class).getUpdates();
    }

    public List<Comment> getNetworkUpdateComments(String updateKey) {
        return ((Comments)this.getService().get(UPDATE_COMMENTS_URL, Comments.class, new Object[]{updateKey})).getComments();
    }

    public void createNetworkUpdate(String update) {
        HashMap<String, String> activity = new HashMap<String, String>();
        activity.put("contentType", "linkedin-html");
        activity.put("body", update);
        this.getService().put(ACTIVITY_URL, activity, new Object[0]);
    }

    public CurrentShare getCurrentShare() {
        return ((UpdateContentShare)this.getService().get(CURRENT_SHARE_URL, UpdateContentShare.class)).getCurrentShare();
    }

    public String share(NewShare share) {
        return this.getService().post(SHARE_URL, (Object)share, new Object[0]);
    }

    public void likeNetworkUpdate(String updateKey) {
        this.getService().put(UPDATE_IS_LIKED_URL, (Object)Boolean.TRUE, new Object[]{updateKey});
    }

    public void unlikeNetworkUpdate(String updateKey) {
        this.getService().put(UPDATE_IS_LIKED_URL, (Object)Boolean.FALSE, new Object[]{updateKey});
    }

    public void commentOnNetworkUpdate(String updateKey, String comment) {
        this.getService().put(UPDATE_COMMENTS_URL, Collections.singletonMap("comment", comment), new Object[]{updateKey});
    }

    public List<LinkedInProfile> getNetworkUpdateLikes(String updateKey) {
        return ((Likes)this.getService().get(UPDATE_LIKES_URL, Likes.class, new Object[]{updateKey})).getLikes();
    }

    public String getNetworkUpdatesJson(NetworkUpdateParameters parameters) {
        return this.getNetworkUpdates(parameters, String.class);
    }

    private <T> T getNetworkUpdates(NetworkUpdateParameters parameters, Class<T> responseType) {
        return (T)this.getService().get(this.buildUri(UPDATES_URL, parameters), responseType);
    }

    static {
        StringBuffer b = new StringBuffer();
        for (UpdateTypeInput t : UpdateTypeInput.values()) {
            b.append("&type=").append(t);
        }
        UPDATE_TYPE_ALL_STRING = b.toString();
        UPDATES_URL = BASE_URL + "{0}/network/updates?format=json";
        UPDATE_COMMENTS_URL = BASE_URL + "~/network/updates/key={0}/update-comments?format=json";
        UPDATE_LIKES_URL = BASE_URL + "~/network/updates/key={0}/likes?format=json";
        UPDATE_IS_LIKED_URL = BASE_URL + "~/network/updates/key={0}/is-liked?format=json";
        ACTIVITY_URL = BASE_URL + "~/person-activities";
        CURRENT_SHARE_URL = BASE_URL + "~:(current-share)";
        SHARE_URL = BASE_URL + "~/shares";
    }

    public static enum networkUpdatesFields {
        COUNT("count"),
        START("start"),
        SCOPE("scope"),
        BEFORE("before"),
        AFTER("after"),
        SHOW_HIDDEN_MEMBERS("show-hidden-members");

        private final String urlName;

        private networkUpdatesFields(String urlName) {
            this.urlName = urlName;
        }

        public String toString() {
            return this.urlName;
        }
    }
}

