/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.model;

import org.agorava.core.api.UserProfile;
import org.agorava.linkedin.model.ConnectionAuthorization;
import org.agorava.linkedin.model.UrlResource;

public class LinkedInProfile
extends UserProfile {
    private static final long serialVersionUID = 7722034568276602636L;
    private final String firstName;
    private final String lastName;
    private final String headline;
    private final String industry;
    private final UrlResource siteStandardProfileRequest;
    private final String publicProfileUrl;
    private final String profilePictureUrl;
    private String summary;
    private ConnectionAuthorization connectionAuthorization;

    public LinkedInProfile(String id, String firstName, String lastName, String headline, String industry, String publicProfileUrl, UrlResource siteStandardProfileRequest, String profilePictureUrl) {
        super(id);
        this.firstName = firstName;
        this.lastName = lastName;
        this.headline = headline;
        this.industry = industry;
        this.publicProfileUrl = publicProfileUrl;
        this.siteStandardProfileRequest = siteStandardProfileRequest;
        this.profilePictureUrl = profilePictureUrl;
    }

    public String getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getHeadline() {
        return this.headline;
    }

    public String getIndustry() {
        return this.industry;
    }

    public UrlResource getSiteStandardProfileRequest() {
        return this.siteStandardProfileRequest;
    }

    public String getPublicProfileUrl() {
        return this.publicProfileUrl;
    }

    public String getProfilePictureUrl() {
        return this.profilePictureUrl;
    }

    public String getSummary() {
        return this.summary;
    }

    public ConnectionAuthorization getConnectionAuthorization() {
        return this.connectionAuthorization;
    }

    public String getProfileImageUrl() {
        return this.profilePictureUrl;
    }

    public String getFullName() {
        return String.valueOf(this.getFirstName()) + " " + this.getLastName();
    }
}

