/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.sshd.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adeptnet.prtg.config.impl.ConfigImplementation;
import org.adeptnet.prtg.config.xml.JaxbManager;
import org.adeptnet.prtg.sshd.SshdConfigInterface;

public class SshdConfigImplementation
extends ConfigImplementation
implements SshdConfigInterface {
    private static final Logger LOG = Logger.getLogger(SshdConfigImplementation.class.getName());
    private String usersFile;
    private Properties users;
    private long usersModified;
    private String publicKeysFile;
    private List<String> publicKeys;
    private long publicKeysModified;
    private String prtgPathPrefix;

    public SshdConfigImplementation(JaxbManager jaxb) {
        super(jaxb);
    }

    public String getUsersFile() {
        return this.usersFile;
    }

    public void setUsersFile(String usersFile) {
        this.usersFile = usersFile;
        this.users = null;
    }

    public SshdConfigImplementation withUsersFile(String usersFile) {
        this.setUsersFile(usersFile);
        return this;
    }

    @Override
    public Properties getUsers() {
        File f;
        if (this.users == null) {
            this.users = new Properties();
            try {
                File f2 = new File(this.usersFile);
                this.usersModified = f2.lastModified();
                this.users.load(new FileInputStream(f2));
                LOG.log(Level.INFO, String.format("getUsers(): Loaded (%d) Users from (%s)", this.users.size(), this.usersFile));
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, String.format("getUsers(): %s", ex.getMessage()), ex);
            }
        } else if (this.usersFile != null && (f = new File(this.usersFile)).lastModified() != this.usersModified) {
            this.users = null;
            return this.getUsers();
        }
        return this.users;
    }

    public void setUsers(Properties users) {
        this.users = users;
        this.usersFile = null;
    }

    public SshdConfigImplementation withUsers(Properties users) {
        this.setUsers(users);
        return this;
    }

    public String getPublicKeysFile() {
        return this.publicKeysFile;
    }

    public void setPublicKeysFile(String publicKeysFile) {
        this.publicKeysFile = publicKeysFile;
        this.publicKeys = null;
    }

    public void setPublicKeys(List<String> publicKeys) {
        this.publicKeys = publicKeys;
        this.publicKeysFile = null;
    }

    public SshdConfigImplementation withPublicKeys(List<String> publicKeys) {
        this.setPublicKeys(publicKeys);
        return this;
    }

    public SshdConfigImplementation withPublicKeysFile(String publicKeysFile) {
        this.setPublicKeysFile(publicKeysFile);
        return this;
    }

    public SshdConfigImplementation withXml(String xml) {
        return (SshdConfigImplementation)super.withXml(xml);
    }

    public SshdConfigImplementation withJmxInitialContext(String jmxInitialContext) {
        return (SshdConfigImplementation)super.withJmxInitialContext(jmxInitialContext);
    }

    @Override
    public List<String> getPublicKeys() {
        File f;
        if (this.publicKeys == null) {
            try {
                Path path = Paths.get(this.publicKeysFile, new String[0]);
                this.publicKeysModified = path.toFile().lastModified();
                this.publicKeys = Files.readAllLines(path, Charset.defaultCharset());
                LOG.log(Level.INFO, String.format("getPublicKeys(): Loaded (%d) Keys from (%s)", this.publicKeys.size(), this.publicKeysFile));
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, String.format("getPublicKeys(): %s", ex.getMessage()), ex);
                this.publicKeys = Collections.emptyList();
            }
        } else if (this.publicKeysFile != null && (f = new File(this.publicKeysFile)).lastModified() != this.publicKeysModified) {
            this.publicKeys = null;
            return this.getPublicKeys();
        }
        return this.publicKeys;
    }

    @Override
    public String getPrtgPathPrefix() {
        return this.prtgPathPrefix;
    }

    public void setPrtgPathPrefix(String prtgPathPrefix) {
        this.prtgPathPrefix = prtgPathPrefix;
    }

    public SshdConfigImplementation withPrtgPathPrefix(String prtgPathPrefix) {
        this.setPrtgPathPrefix(prtgPathPrefix);
        return this;
    }
}

