/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.sshd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adeptnet.prtg.sshd.BaseCommand;
import org.adeptnet.prtg.sshd.SshdConfigInterface;
import org.apache.sshd.server.Environment;

public class PrtgShellCommand
extends BaseCommand
implements Runnable,
Thread.UncaughtExceptionHandler {
    private static final Logger LOG = Logger.getLogger(PrtgShellCommand.class.getName());
    private final String ECHO = "echo";
    private final String EXIT = "exit";
    private final String MULTILINE = ";";
    private Thread thread;

    public PrtgShellCommand(SshdConfigInterface configInterface) {
        super(configInterface);
    }

    public void start(Environment env) throws IOException {
        this.setEnvironment(env);
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler(this);
        this.thread.start();
    }

    public void destroy() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int exitValue = 0;
        String exitMessage = null;
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(this.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                this.handleLine(line);
            }
        }
        catch (InterruptedIOException isr) {
            this.doExit(exitValue, exitMessage);
        }
        catch (IOException ex) {
            try {
                exitValue = 1;
                exitMessage = ex.getMessage();
                LOG.log(Level.SEVERE, exitMessage, ex);
            }
            catch (Throwable throwable) {
                this.doExit(exitValue, exitMessage);
                throw throwable;
            }
            this.doExit(exitValue, exitMessage);
        }
        this.doExit(exitValue, exitMessage);
    }

    private void handleLine(String line) throws InterruptedIOException, IOException {
        if (line.contains(";")) {
            String[] lines;
            for (String _line : lines = line.split(";")) {
                this.handleLine(_line);
            }
            return;
        }
        if (line.equalsIgnoreCase("exit")) {
            throw new InterruptedIOException();
        }
        if (line.startsWith("echo")) {
            if (line.length() >= 5) {
                this.printLine(line.substring(5));
            } else {
                this.printLine("");
            }
            return;
        }
        if (this.handlePRTG(line)) {
            return;
        }
        this.printLine(String.format("Unknown command: %s", line));
    }

    @Override
    public void uncaughtException(Thread thread, Throwable thrwbl) {
        LOG.log(Level.SEVERE, "Unhandled Exception in ShellCommand: " + thrwbl.getMessage(), thrwbl);
    }
}

