/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.sshd;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.adeptnet.prtg.config.ConfigInterface;
import org.adeptnet.prtg.config.SensorProcess;
import org.adeptnet.prtg.sshd.SshdConfigInterface;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;

public abstract class BaseCommand
implements Command {
    private static final Logger LOG = Logger.getLogger(BaseCommand.class.getName());
    private final String CRLF = "\r\n";
    private final SshdConfigInterface configInterface;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private Environment environment;

    public BaseCommand(SshdConfigInterface configInterface) {
        this.configInterface = configInterface;
    }

    public ConfigInterface getConfigInterface() {
        return this.configInterface;
    }

    public void printLine(String line) throws IOException {
        this.out.write(String.format("%s%s", line, "\r\n").getBytes());
        this.out.flush();
    }

    public void printLineError(String line) throws IOException {
        this.err.write(String.format("%s%s", line, "\r\n").getBytes());
        this.err.flush();
    }

    public void doExit(int exitValue) {
        this.doClose();
        if (this.callback != null) {
            this.callback.onExit(exitValue);
        }
    }

    public void doClose() {
        this.doClose(this.in, this.out, this.err);
    }

    public void doClose(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doExit(int exitValue, String exitMessage) {
        this.doClose();
        if (this.callback != null) {
            this.callback.onExit(exitValue, exitMessage);
        }
    }

    protected boolean handlePRTG(String line) throws IOException {
        if (!line.startsWith(this.configInterface.getPrtgPathPrefix())) {
            return false;
        }
        try {
            this.printLine(new SensorProcess((ConfigInterface)this.configInterface).withSensorName(line.replace(this.configInterface.getPrtgPathPrefix(), "").trim()).run());
        }
        catch (JAXBException ex) {
            String error = String.format("(%s) %s", ((Object)((Object)ex)).getClass().getName(), ex.getMessage());
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            sb.append("<prtg xmlns=\"urn:ietf:params:xml:ns:prtg-1.0\">");
            sb.append("<error>1</error>");
            sb.append("<text>");
            sb.append(error);
            sb.append("</text>");
            sb.append("</prtg>");
            this.printLineError(sb.toString());
            LOG.log(Level.SEVERE, error, ex);
        }
        return true;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }
}

