/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.config;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.bind.JAXBException;
import org.adeptnet.prtg.config.ConfigInterface;
import org.adeptnet.prtg.config.SensorException;
import org.adeptnet.prtg.config.xml.ChannelTypeAttribute;
import org.adeptnet.prtg.config.xml.ChannelTypeBase;
import org.adeptnet.prtg.config.xml.ChannelTypeOperation;
import org.adeptnet.prtg.config.xml.ChannelTypeScript;
import org.adeptnet.prtg.config.xml.Config;
import org.adeptnet.prtg.config.xml.JMXConfigType;
import org.adeptnet.prtg.config.xml.SensorType;
import org.adeptnet.prtg.xml.BooleanType;
import org.adeptnet.prtg.xml.JaxbManager;
import org.adeptnet.prtg.xml.Prtg;

public class SensorProcess {
    private static final Logger LOG = Logger.getLogger(SensorProcess.class.getName());
    private final Prtg prtg = new Prtg();
    private String sensorName;
    private MBeanServerConnection mbsc;
    private Config config;
    private final ConfigInterface configInterface;
    private JaxbManager manager;

    public SensorProcess(ConfigInterface configInterface) {
        this.configInterface = configInterface;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public void setSensorName(String sensorName) {
        this.sensorName = sensorName;
    }

    public SensorProcess withSensorName(String sensorName) {
        this.setSensorName(sensorName);
        return this;
    }

    private String getScript(MBeanServerConnection mbsc, ObjectName bean) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, MBeanException, AttributeNotFoundException {
        StringBuilder sb = new StringBuilder();
        MBeanInfo info = mbsc.getMBeanInfo(bean);
        for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
            String type;
            if (mBeanAttributeInfo.getType().startsWith("[") || mBeanAttributeInfo.getType().contains("$")) {
                Object value = mbsc.getAttribute(bean, mBeanAttributeInfo.getName());
                type = value.getClass().getCanonicalName();
            } else {
                type = mBeanAttributeInfo.getType();
            }
            sb.append(String.format("%s get%s() {\n", type, mBeanAttributeInfo.getName()));
            sb.append(String.format("\treturn jmx.getAttribute(bean, \"%s\");\n", mBeanAttributeInfo.getName()));
            sb.append("}\n\n");
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : info.getOperations()) {
            StringBuilder parmsCall = new StringBuilder();
            StringBuilder parmsValue = new StringBuilder();
            StringBuilder parmsType = new StringBuilder();
            for (MBeanParameterInfo parmInfo : ((MBeanOperationInfo)mBeanFeatureInfo).getSignature()) {
                if (parmsCall.length() > 0) {
                    parmsCall.append(",");
                }
                if (parmsValue.length() > 0) {
                    parmsValue.append(",");
                }
                if (parmsType.length() > 0) {
                    parmsType.append(",");
                }
                String type = parmInfo.getType().startsWith("[") || parmInfo.getType().contains("$") ? "Object" : parmInfo.getType();
                parmsCall.append(String.format("%s %s ", type, parmInfo.getName()));
                parmsValue.append(String.format("%s ", parmInfo.getName()));
                parmsType.append(String.format("\"%s\" ", type));
            }
            String type = ((MBeanOperationInfo)mBeanFeatureInfo).getReturnType().startsWith("[") || ((MBeanOperationInfo)mBeanFeatureInfo).getReturnType().contains("$") ? "Object" : ((MBeanOperationInfo)mBeanFeatureInfo).getReturnType();
            sb.append(String.format("%s %s(%s) {\n", type, mBeanFeatureInfo.getName(), parmsCall.toString().trim()));
            sb.append(String.format("\treturn jmx.invoke(bean, \"%s\", new Object[]{%s}, new String[]{%s});\n", mBeanFeatureInfo.getName(), parmsValue.toString().trim(), parmsType.toString().trim()));
            sb.append("}\n\n");
        }
        return sb.toString();
    }

    private Object interpretBeanShell(String text, Map<String, Object> params) throws SensorException {
        Interpreter bsh = new Interpreter();
        try {
            for (String name : params.keySet()) {
                Object val = params.get(name);
                if (val instanceof Number) {
                    if (val instanceof Integer) {
                        bsh.set(name, ((Integer)val).intValue());
                        continue;
                    }
                    if (val instanceof Long) {
                        bsh.set(name, ((Long)val).longValue());
                        continue;
                    }
                    if (val instanceof Double) {
                        bsh.set(name, ((Double)val).doubleValue());
                        continue;
                    }
                    if (val instanceof Float) {
                        bsh.set(name, ((Float)val).floatValue());
                        continue;
                    }
                    bsh.set(name, val);
                    continue;
                }
                if (val instanceof Boolean) {
                    bsh.set(name, ((Boolean)val).booleanValue());
                    continue;
                }
                bsh.set(name, params.get(name));
            }
            return bsh.eval(text);
        }
        catch (EvalError e) {
            throw new SensorException("Error executing bean script: " + e.getMessage(), e);
        }
    }

    private void processChannel(ChannelTypeBase channel) throws SensorException {
        try {
            Object result;
            ObjectName bean = new ObjectName(channel.getJmxObjectName());
            if (channel instanceof ChannelTypeAttribute) {
                ChannelTypeAttribute _channel = (ChannelTypeAttribute)channel.upCast(ChannelTypeAttribute.class);
                result = _channel.getLookupValue(this.mbsc.getAttribute(bean, _channel.getJmxMethod()));
            } else if (channel instanceof ChannelTypeOperation) {
                ChannelTypeOperation _channel = (ChannelTypeOperation)channel.upCast(ChannelTypeOperation.class);
                List<Serializable> values = _channel.getJmxParameters().getValues();
                Object[] parms = new Object[values.size()];
                String[] parmsType = new String[values.size()];
                for (int x = 0; x < values.size(); ++x) {
                    parms[x] = values.get(x);
                    parmsType[x] = values.get(x).getClass().getName();
                }
                result = _channel.getLookupValue(this.mbsc.invoke(bean, _channel.getJmxMethod(), parms, parmsType));
            } else if (channel instanceof ChannelTypeScript) {
                ChannelTypeScript _channel = (ChannelTypeScript)channel.upCast(ChannelTypeScript.class);
                String data = String.format("%s%s", this.getScript(this.mbsc, bean), _channel.getJmxScript());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("jmx", this.mbsc);
                params.put("bean", bean);
                try {
                    result = this.interpretBeanShell(data, params);
                }
                catch (SensorException ex) {
                    throw new SensorException(String.format("ChannelTypeScript: %s", ex.getMessage()), ex);
                }
            } else {
                throw new SensorException(String.format("Unknown ChannelType: %s", channel.getClass().getName()));
            }
            if (!channel.isCreateChannel()) {
                return;
            }
            this.prtg.getResult().add(channel.withValue(result));
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | IntrospectionException | MBeanException | MalformedObjectNameException | ReflectionException ex) {
            throw new SensorException(String.format("processChannel: %s - (%s)%s", channel.getName(), ex.getClass().getName(), ex.getMessage()), ex);
        }
    }

    private void process() throws SensorException, MalformedURLException, IOException {
        SensorType sensor = this.config.getSensorByName(this.sensorName);
        if (sensor == null) {
            throw new SensorException(String.format("Cannot find SensorName: %s", this.sensorName));
        }
        JMXConfigType jmx = this.config.getJMXByName(sensor.getJmxName());
        if (jmx == null) {
            throw new SensorException(String.format("Cannot find JMX: %s", sensor.getJmxName()));
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        String[] credentials = new String[]{jmx.getUserName(), jmx.getPassword()};
        env.put("jmx.remote.credentials", credentials);
        if (this.configInterface.getJmxInitialContext() != null) {
            env.put("java.naming.factory.initial", this.configInterface.getJmxInitialContext());
        }
        JMXServiceURL url = new JMXServiceURL(jmx.getUrl());
        try (JMXConnector jmxc = JMXConnectorFactory.connect(url, env);){
            this.mbsc = jmxc.getMBeanServerConnection();
            for (ChannelTypeBase channel : sensor.getChannels()) {
                this.processChannel(channel);
            }
        }
    }

    private JaxbManager getManager() {
        if (this.manager == null) {
            this.manager = new JaxbManager();
        }
        return this.manager;
    }

    public String run() throws JAXBException {
        try {
            this.config = this.configInterface.getConfig();
            if (this.config == null) {
                throw new SensorException("Please setup configInterface");
            }
            if (this.sensorName == null || this.sensorName.isEmpty()) {
                throw new SensorException("No parameter: name");
            }
            LOG.info(String.format("run(): %s", this.sensorName));
            this.process();
        }
        catch (Throwable ex) {
            Throwable _ex = ex instanceof JAXBException ? ((JAXBException)ex).getLinkedException() : ex;
            this.prtg.setError(BooleanType.TRUE);
            this.prtg.setErrorText(String.format("%s: %s", ex.getClass().getName(), _ex));
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return this.getManager().toXML((Object)this.prtg);
    }
}

