/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.prtg.config.impl;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.adeptnet.prtg.config.ConfigInterface;
import org.adeptnet.prtg.config.xml.Config;
import org.adeptnet.prtg.config.xml.JaxbManager;

public class ConfigImplementation
implements ConfigInterface {
    private static final Logger LOG = Logger.getLogger(ConfigImplementation.class.getName());
    private Config config;
    private String xml;
    private long xmlModified;
    private String jmxInitialContext;
    private final JaxbManager jaxb;

    public ConfigImplementation(JaxbManager jaxb) {
        this.jaxb = jaxb;
    }

    @Override
    public Config getConfig() throws JAXBException {
        File f;
        if (this.config == null) {
            File f2 = new File(this.xml);
            this.xmlModified = f2.lastModified();
            this.config = this.jaxb.toConfig(f2);
            LOG.log(Level.INFO, String.format("getConfig(): Loaded config from (%s)", this.xml));
        } else if (this.xml != null && (f = new File(this.xml)).lastModified() != this.xmlModified) {
            this.config = null;
            return this.getConfig();
        }
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        this.xml = null;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
        this.config = null;
    }

    public ConfigImplementation withConfig(Config config) {
        this.setConfig(config);
        return this;
    }

    public ConfigImplementation withXml(String xml) {
        this.setXml(xml);
        return this;
    }

    @Override
    public String getJmxInitialContext() {
        return this.jmxInitialContext;
    }

    public void setJmxInitialContext(String jmxInitialContext) {
        this.jmxInitialContext = jmxInitialContext;
    }

    public ConfigImplementation withJmxInitialContext(String jmxInitialContext) {
        this.setJmxInitialContext(jmxInitialContext);
        return this;
    }
}

