/*
 * Decompiled with CFR 0.152.
 */
package org.adeptnet.auth.saml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.adeptnet.auth.saml.SAMLException;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPConfig {
    private String entityId;
    private String acs;

    public SPConfig() {
    }

    public SPConfig(File metadataFile) throws SAMLException {
        EntityDescriptor edesc;
        BasicParserPool parsers = new BasicParserPool();
        parsers.setNamespaceAware(true);
        try {
            Document doc = parsers.parse((InputStream)new FileInputStream(metadataFile));
            Element root = doc.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            edesc = (EntityDescriptor)unmarshallerFactory.getUnmarshaller(root).unmarshall(root);
        }
        catch (IOException | UnmarshallingException | XMLParserException e) {
            throw new SAMLException(e);
        }
        SPSSODescriptor spDesc = edesc.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (spDesc == null) {
            throw new SAMLException("No SP SSO descriptor found");
        }
        String acsUrl = null;
        for (AssertionConsumerService svc : spDesc.getAssertionConsumerServices()) {
            if (!svc.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && !svc.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
            acsUrl = svc.getLocation();
            break;
        }
        if (acsUrl == null) {
            throw new SAMLException("No acceptable Assertion Consumer Service found");
        }
        this.setEntityId(edesc.getEntityID());
        this.setAcs(acsUrl);
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setAcs(String acs) {
        this.acs = acs;
    }

    public String getAcs() {
        return this.acs;
    }
}

