/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.impl;

import java.util.List;
import java.util.Set;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.ContentReference;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.LazySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLObjectContentReference
implements ContentReference {
    private final Logger log = LoggerFactory.getLogger(SAMLObjectContentReference.class);
    private SignableSAMLObject signableObject;
    private String digestAlgorithm;
    private List<String> transforms;

    public SAMLObjectContentReference(SignableSAMLObject newSignableObject) {
        this.signableObject = newSignableObject;
        this.transforms = new LazyList<String>();
        if (Configuration.getGlobalSecurityConfiguration() != null) {
            this.digestAlgorithm = Configuration.getGlobalSecurityConfiguration().getSignatureReferenceDigestMethod();
        }
        if (this.digestAlgorithm == null) {
            this.digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        this.transforms.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        this.transforms.add("http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public List<String> getTransforms() {
        return this.transforms;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String newAlgorithm) {
        this.digestAlgorithm = newAlgorithm;
    }

    @Override
    public void createReference(XMLSignature signature) {
        try {
            Transforms dsigTransforms = new Transforms(signature.getDocument());
            for (int i = 0; i < this.transforms.size(); ++i) {
                String transform = this.transforms.get(i);
                dsigTransforms.addTransform(transform);
                if (!transform.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") && !transform.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) continue;
                this.processExclusiveTransform(signature, dsigTransforms.item(i));
            }
            if (!DatatypeHelper.isEmpty(this.signableObject.getSignatureReferenceID())) {
                signature.addDocument("#" + this.signableObject.getSignatureReferenceID(), dsigTransforms, this.digestAlgorithm);
            } else {
                this.log.debug("SignableSAMLObject had no reference ID, signing using whole document Reference URI");
                signature.addDocument("", dsigTransforms, this.digestAlgorithm);
            }
        }
        catch (TransformationException e) {
            this.log.error("Unsupported signature transformation", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            this.log.error("Error adding content reference to signature", (Throwable)e);
        }
    }

    private void processExclusiveTransform(XMLSignature signature, Transform transform) {
        this.log.debug("Adding list of inclusive namespaces for signature exclusive canonicalization transform");
        LazySet<String> inclusiveNamespacePrefixes = new LazySet<String>();
        this.populateNamespacePrefixes(inclusiveNamespacePrefixes, this.signableObject);
        if (inclusiveNamespacePrefixes != null && inclusiveNamespacePrefixes.size() > 0) {
            InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(signature.getDocument(), inclusiveNamespacePrefixes);
            transform.getElement().appendChild(inclusiveNamespaces.getElement());
        }
    }

    private void populateNamespacePrefixes(Set<String> namespacePrefixes, XMLObject signatureContent) {
        for (String prefix : signatureContent.getNamespaceManager().getNonVisibleNamespacePrefixes()) {
            if (prefix == null) continue;
            if ("#default".equals(prefix)) {
                namespacePrefixes.add("xmlns");
                continue;
            }
            namespacePrefixes.add(prefix);
        }
    }
}

