/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.process.model.services.validate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.cloud.services.process.model.services.validate.ValidationErrorRepresentation;
import org.activiti.validation.ProcessValidatorImpl;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessModelValidatorService {
    private final ProcessValidatorImpl processValidator;
    private final BpmnXMLConverter bpmnXmlConverter;

    public ProcessModelValidatorService(ProcessValidatorImpl processValidator, BpmnXMLConverter bpmnXmlConverter) {
        this.processValidator = processValidator;
        this.bpmnXmlConverter = bpmnXmlConverter;
    }

    public List<ValidationErrorRepresentation> validate(byte[] file) throws XMLStreamException, IOException {
        try (InputStreamReader xmlIn = new InputStreamReader((InputStream)new ByteArrayInputStream(file), "UTF-8");){
            XMLInputFactory xif = BpmnXMLUtil.createSafeXmlInputFactory();
            XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
            BpmnModel bpmnModel = this.bpmnXmlConverter.convertToBpmnModel(xtr);
            if (CollectionUtils.isEmpty((Collection)bpmnModel.getProcesses())) {
                throw new IllegalStateException("No process found for validation.");
            }
            List<ValidationErrorRepresentation> list = this.processValidator.validate(bpmnModel).stream().map(ValidationErrorRepresentation::new).collect(Collectors.toList());
            return list;
        }
    }
}

