/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.core.pageable.sort;

import org.activiti.cloud.services.core.pageable.sort.SortApplier;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public abstract class BaseSortApplier<T extends Query<?, ?>>
implements SortApplier<T> {
    @Override
    public void applySort(T query, Pageable pageable) {
        if (pageable.getSort() != null && pageable.getSort() != Sort.unsorted()) {
            this.applyPageableSort(query, pageable.getSort());
        } else {
            this.applyDefaultSort(query);
        }
    }

    protected abstract void applyDefaultSort(T var1);

    private void applyPageableSort(T query, Sort sort) {
        for (Sort.Order order : sort) {
            this.applyOrder(query, order);
            this.applyDirection(query, order.getDirection());
        }
    }

    private void applyOrder(T query, Sort.Order order) {
        QueryProperty property = this.getOrderByProperty(order);
        if (property == null) {
            throw new ActivitiIllegalArgumentException("The property '" + order.getProperty() + "' cannot be used to sort the result.");
        }
        query.orderBy(property);
    }

    protected abstract QueryProperty getOrderByProperty(Sort.Order var1);

    private void applyDirection(T query, Sort.Direction direction) {
        switch (direction) {
            case ASC: {
                query.asc();
                break;
            }
            case DESC: {
                query.desc();
            }
        }
    }
}

