/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.core;

import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiException;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.image.exception.ActivitiImageException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ProcessDiagramGeneratorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDiagramGeneratorWrapper.class);
    private final ProcessDiagramGenerator processDiagramGenerator;
    @Value(value="${activiti.diagram.activity.font:}")
    private String activityFontName;
    @Value(value="${activiti.diagram.label.font:}")
    private String labelFontName;
    @Value(value="${activiti.diagram.annotation.font:}")
    private String annotationFontName;
    @Value(value="${activiti.diagram.default.image.file:}")
    private String defaultDiagramImageFileName;
    @Value(value="${activiti.diagram.generate.default:false}")
    private boolean generateDefaultDiagram;

    @Autowired
    public ProcessDiagramGeneratorWrapper(ProcessDiagramGenerator processDiagramGenerator) {
        this.processDiagramGenerator = processDiagramGenerator;
    }

    public byte[] generateDiagram(BpmnModel bpmnModel) {
        return this.generateDiagram(bpmnModel, Collections.emptyList(), Collections.emptyList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] generateDiagram(BpmnModel bpmnModel, List<String> highLightedActivities, List<String> highLightedFlows) {
        try (InputStream imageStream = this.processDiagramGenerator.generateDiagram(bpmnModel, highLightedActivities, highLightedFlows, this.getActivityFontName(), this.getLabelFontName(), this.getAnnotationFontName(), this.isGenerateDefaultDiagram(), this.getDiagramImageFileName());){
            byte[] byArray = IOUtils.toByteArray((InputStream)imageStream);
            return byArray;
        }
        catch (ActivitiImageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActivitiException("Error occurred while getting process diagram for model: " + bpmnModel, (Throwable)e);
        }
    }

    public boolean isGenerateDefaultDiagram() {
        return this.generateDefaultDiagram;
    }

    public String getDefaultDiagramImageFileName() {
        return this.defaultDiagramImageFileName;
    }

    public String getDiagramImageFileName() {
        return !StringUtils.isEmpty((Object)this.getDefaultDiagramImageFileName()) ? this.getDefaultDiagramImageFileName() : this.processDiagramGenerator.getDefaultDiagramImageFileName();
    }

    public String getActivityFontName() {
        return this.isFontAvailable(this.activityFontName) ? this.activityFontName : this.processDiagramGenerator.getDefaultActivityFontName();
    }

    public String getLabelFontName() {
        return this.isFontAvailable(this.labelFontName) ? this.labelFontName : this.processDiagramGenerator.getDefaultLabelFontName();
    }

    public String getAnnotationFontName() {
        return this.isFontAvailable(this.annotationFontName) ? this.annotationFontName : this.processDiagramGenerator.getDefaultAnnotationFontName();
    }

    private boolean isFontAvailable(String fontName) {
        if (StringUtils.isEmpty((Object)fontName)) {
            return false;
        }
        boolean available = Arrays.stream(this.getAvailableFonts()).anyMatch(availbleFontName -> availbleFontName.toLowerCase().startsWith(fontName.toLowerCase()));
        if (!available) {
            LOGGER.debug("Font not available while generating process diagram: " + fontName);
        }
        return available;
    }

    protected String[] getAvailableFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }
}

