/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.jetty;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.adapters.jetty.JettyAcegiUserRealm;
import org.acegisecurity.adapters.jetty.JettyAcegiUserToken;
import org.mortbay.http.UserPrincipal;

public class JettyAcegiUserRealmTests
extends TestCase {
    private final String ADAPTER_KEY = "my_key";
    private final String REALM_NAME = "Acegi Powered Realm";
    static /* synthetic */ Class class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealmTests;

    public JettyAcegiUserRealmTests() {
    }

    public JettyAcegiUserRealmTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealmTests == null ? (class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealmTests = JettyAcegiUserRealmTests.class$("org.acegisecurity.adapters.jetty.JettyAcegiUserRealmTests")) : class$org$acegisecurity$adapters$jetty$JettyAcegiUserRealmTests));
    }

    private JettyAcegiUserRealm makeAdapter(String fileName) throws Exception {
        String useFile = "org/acegisecurity/adapters/" + fileName;
        return new JettyAcegiUserRealm("Acegi Powered Realm", "my_key", useFile);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAdapterAbortsIfAppContextDoesNotContainAnAuthenticationBean() throws Exception {
        try {
            JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-invalid.xml");
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertEquals((String)"Bean context must contain at least one bean of type AuthenticationManager", (String)expected.getMessage());
        }
    }

    public void testAdapterAbortsIfNoAppContextSpecified() throws Exception {
        try {
            new JettyAcegiUserRealm("Acegi Powered Realm", "my_key", null);
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertEquals((String)"appContextLocation must be specified", (String)expected.getMessage());
        }
        try {
            new JettyAcegiUserRealm("Acegi Powered Realm", "my_key", "");
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertEquals((String)"appContextLocation must be specified", (String)expected.getMessage());
        }
    }

    public void testAdapterAbortsIfNoKeySpecified() throws Exception {
        try {
            new JettyAcegiUserRealm("Acegi Powered Realm", null, "SOME_PATH");
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertEquals((String)"key must be specified", (String)expected.getMessage());
        }
        try {
            new JettyAcegiUserRealm("Acegi Powered Realm", "", "SOME_PATH");
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertEquals((String)"key must be specified", (String)expected.getMessage());
        }
    }

    public void testAdapterAbortsIfNoRealmNameSpecified() throws Exception {
        try {
            new JettyAcegiUserRealm(null, "my_key", "SOME_PATH");
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertEquals((String)"realm must be specified", (String)expected.getMessage());
        }
        try {
            new JettyAcegiUserRealm(null, "my_key", "SOME_PATH");
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertEquals((String)"realm must be specified", (String)expected.getMessage());
        }
    }

    public void testAdapterAbortsWithIncorrectApplicationContextLocation() throws Exception {
        try {
            new JettyAcegiUserRealm("Acegi Powered Realm", "my_key", "SOME_INVALID_LOCATION");
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertTrue((boolean)expected.getMessage().startsWith("Cannot locate"));
        }
    }

    public void testAdapterIdentifiesTheRealmItManages() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        JettyAcegiUserRealmTests.assertEquals((String)"Acegi Powered Realm", (String)adapter.getName());
    }

    public void testAdapterStartsUpSuccess() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        JettyAcegiUserRealmTests.assertTrue((boolean)true);
    }

    public void testAuthenticationFailsForIncorrectPassword() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        JettyAcegiUserRealmTests.assertEquals(null, (Object)adapter.authenticate("marissa", (Object)"kangaroo", null));
    }

    public void testAuthenticationFailsForIncorrectUserName() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        JettyAcegiUserRealmTests.assertEquals(null, (Object)adapter.authenticate("melissa", (Object)"koala", null));
    }

    public void testAuthenticationSuccess() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        UserPrincipal result = adapter.authenticate("marissa", (Object)"koala", null);
        if (!(result instanceof JettyAcegiUserToken)) {
            JettyAcegiUserRealmTests.fail((String)"Should have returned JettyAcegiUserToken");
        }
        JettyAcegiUserToken castResult = (JettyAcegiUserToken)result;
        JettyAcegiUserRealmTests.assertEquals((Object)"marissa", (Object)castResult.getPrincipal());
        JettyAcegiUserRealmTests.assertEquals((Object)"koala", (Object)castResult.getCredentials());
        JettyAcegiUserRealmTests.assertEquals((String)"ROLE_TELLER", (String)castResult.getAuthorities()[0].getAuthority());
        JettyAcegiUserRealmTests.assertEquals((String)"ROLE_SUPERVISOR", (String)castResult.getAuthorities()[1].getAuthority());
        JettyAcegiUserRealmTests.assertEquals((int)"my_key".hashCode(), (int)castResult.getKeyHash());
    }

    public void testAuthenticationWithNullPasswordHandledGracefully() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        JettyAcegiUserRealmTests.assertEquals(null, (Object)adapter.authenticate("marissa", null, null));
    }

    public void testAuthenticationWithNullUserNameHandledGracefully() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        JettyAcegiUserRealmTests.assertEquals(null, (Object)adapter.authenticate(null, (Object)"koala", null));
    }

    public void testDisassociateImplemented() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        adapter.disassociate((UserPrincipal)new MockUserPrincipal());
        JettyAcegiUserRealmTests.assertTrue((boolean)true);
    }

    public void testGetAuthenticationManager() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        JettyAcegiUserRealmTests.assertTrue((adapter.getAuthenticationManager() != null ? 1 : 0) != 0);
    }

    public void testLogoutImplemented() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        adapter.logout((UserPrincipal)new MockUserPrincipal());
        JettyAcegiUserRealmTests.assertTrue((boolean)true);
    }

    public void testNoArgsConstructor() {
        try {
            new JettyAcegiUserRealm();
            JettyAcegiUserRealmTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JettyAcegiUserRealmTests.assertTrue((boolean)true);
        }
    }

    public void testPopRoleImplemented() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        MockUserPrincipal user = new MockUserPrincipal();
        JettyAcegiUserRealmTests.assertEquals((Object)user, (Object)adapter.popRole((UserPrincipal)user));
    }

    public void testPushRoleImplemented() throws Exception {
        JettyAcegiUserRealm adapter = this.makeAdapter("adaptertest-valid.xml");
        MockUserPrincipal user = new MockUserPrincipal();
        JettyAcegiUserRealmTests.assertEquals((Object)user, (Object)adapter.pushRole((UserPrincipal)user, "SOME_ROLE"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockUserPrincipal
    implements UserPrincipal {
        private MockUserPrincipal() {
        }

        public String getName() {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public boolean isAuthenticated() {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public boolean isUserInRole(String arg0) {
            throw new UnsupportedOperationException("mock method not implemented");
        }
    }
}

