/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal.commons;

public final class VLQUtil {
    private static final String VALUE_MUST_NOT_BE_NEGATIVE_MESSAGE = "value must not be negative";
    private static final String VLQ_ENCODED_NUMBER_TO_LARGE_FOR_UINT_MESSAGE = "VLQ encoded number too large to fit into an unsigned int. Try to read it in a long.";
    private static final int MAX_7BIT_INT_VALUE = 127;
    private static final long SIGN_BYTE_MASK = 128L;
    private static final int UNSIGNED_INT_BYTE_MASK = 127;

    public static int decodeUnsignedIntFromVLQ(ByteSupplier byteSupplier) {
        int value = 0;
        int shift = 0;
        do {
            byte byteRead = byteSupplier.get();
            value |= (byteRead & 0x7F) << shift;
            if (byteRead >= 0) continue;
            if (shift == 28 && (byteRead & 0x78) != 0) break;
            return value;
        } while ((shift += 7) <= 28);
        throw new IllegalStateException(VLQ_ENCODED_NUMBER_TO_LARGE_FOR_UINT_MESSAGE);
    }

    public static void encodeUnsignedIntAsVLQ(int value, ByteConsumer byteConsumer) {
        VLQUtil.encodeUnsignedLongAsVLQ(value, byteConsumer);
    }

    private static void encodeUnsignedLongAsVLQ(long value, ByteConsumer byteConsumer) {
        boolean endReached;
        if (value < 0L) {
            throw new IllegalArgumentException(VALUE_MUST_NOT_BE_NEGATIVE_MESSAGE);
        }
        long v = value;
        do {
            endReached = v <= 127L;
            long byteToWrite = v & 0x7FL | (endReached ? 128L : 0L);
            v >>= 7;
            byteConsumer.accept((byte)byteToWrite);
        } while (!endReached);
    }

    public static interface ByteConsumer {
        public void accept(byte var1);
    }

    public static interface ByteSupplier {
        public byte get();
    }
}

