/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal.commons;

import java.util.regex.Pattern;
import org.abego.stringgraph.internal.commons.ObjectUtil;
import org.eclipse.jdt.annotation.Nullable;

public final class StringUtil {
    public static final String NULL_STRING = "null";
    private static final char DOUBLE_QUOTE_CHAR = '\"';
    private static final char BEL_CHAR = '\b';
    private static final char FORM_FEED_CHAR = '\f';
    private static final char NEWLINE_CHAR = '\n';
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char TAB_CHAR = '\t';
    private static final char BACKSLASH_CHAR = '\\';
    private static final char SINGLE_QUOTE_CHAR = '\'';
    private static final int FIRST_PRINTABLE_ASCII_CHAR_VALUE = 32;
    private static final int LAST_PRINTABLE_ASCII_CHAR_VALUE = 127;
    private static final Pattern NO_QUOTES_NEEDED_PATTERN = Pattern.compile("[-\\w_+*=.:;/@?&#()\\[\\]{}<>]+");

    StringUtil() {
        throw new UnsupportedOperationException();
    }

    public static String quoted2(@Nullable String text) {
        return StringUtil.quoted2(text, NULL_STRING);
    }

    private static String quoted2(@Nullable String text, String nullResult) {
        return StringUtil.quotedHelper(text, nullResult, '\"', "'", "\\\"", StringUtil::append);
    }

    private static String quotedHelper(@Nullable String text, String nullResult, char quoteChar, String singleQuoteText, String doubleQuoteText, StringBuilderAppender nonAsciiCharHandler) {
        if (text == null) {
            return nullResult;
        }
        StringBuilder result = new StringBuilder();
        result.append(quoteChar);
        StringUtil.appendEscapedString(result, text, singleQuoteText, doubleQuoteText, nonAsciiCharHandler);
        result.append(quoteChar);
        return result.toString();
    }

    private static void appendEscapedString(StringBuilder stringBuilder, @Nullable String text, String singleQuoteText, String doubleQuoteText, StringBuilderAppender nonASCIICharAppender) {
        if (text != null) {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                StringUtil.appendEscapedChar(stringBuilder, c, singleQuoteText, doubleQuoteText, nonASCIICharAppender);
            }
        }
    }

    private static void appendEscapedChar(StringBuilder stringBuilder, char character, String singleQuoteText, String doubleQuoteText, StringBuilderAppender nonASCIICharAppender) {
        switch (character) {
            case '\b': {
                stringBuilder.append("\\b");
                break;
            }
            case '\f': {
                stringBuilder.append("\\f");
                break;
            }
            case '\n': {
                stringBuilder.append("\\n");
                break;
            }
            case '\r': {
                stringBuilder.append("\\r");
                break;
            }
            case '\t': {
                stringBuilder.append("\\t");
                break;
            }
            case '\\': {
                stringBuilder.append("\\\\");
                break;
            }
            case '\"': {
                stringBuilder.append(doubleQuoteText);
                break;
            }
            case '\'': {
                stringBuilder.append(singleQuoteText);
                break;
            }
            default: {
                if (character < ' ') {
                    StringUtil.appendUnicodeEscaped(stringBuilder, character);
                    break;
                }
                if (character > '\u007f') {
                    nonASCIICharAppender.append(stringBuilder, character);
                    break;
                }
                stringBuilder.append(character);
            }
        }
    }

    private static void appendUnicodeEscaped(StringBuilder stringBuilder, char character) {
        String n = Integer.toHexString(character);
        stringBuilder.append("\\u");
        stringBuilder.append("0000".substring(n.length()));
        stringBuilder.append(n);
    }

    private static void append(StringBuilder stringBuilder, char character) {
        stringBuilder.append(character);
    }

    public static String quotedIfNeeded(String s) {
        return StringUtil.needsQuotes(s) ? StringUtil.quoted2(s) : s;
    }

    private static boolean needsQuotes(String s) {
        return !NO_QUOTES_NEEDED_PATTERN.matcher(s).matches();
    }

    public static int compareToIgnoreCaseStable(String s1, String s2) {
        return ObjectUtil.compareAsTexts(s1, s2);
    }

    private static interface StringBuilderAppender {
        public void append(StringBuilder var1, char var2);
    }
}

