/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal.commons;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.jdt.annotation.Nullable;

public final class FileUtil {
    private FileUtil() {
    }

    public static void ensureDirectoryExists(@Nullable File directory) {
        if (directory == null) {
            return;
        }
        if (!directory.exists()) {
            boolean success = directory.mkdirs();
            if (!success) {
                throw new UncheckedIOException(new FileNotFoundException(String.format("Directory does not exist and could not be created: %s", directory.getAbsolutePath())));
            }
        } else if (!directory.isDirectory()) {
            throw new UncheckedIOException(new IOException(String.format("File exists but is not a directory: %s", directory.getAbsolutePath())));
        }
    }

    public static void ensureFileExists(File file) {
        if (!file.exists()) {
            FileUtil.ensureDirectoryExists(file.getParentFile());
            try {
                boolean wasCreate = file.createNewFile();
                if (!wasCreate) {
                    throw new IllegalStateException("Trying to create file that already exists: " + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

