/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal.commons;

import java.util.Comparator;
import org.abego.stringgraph.core.Edge;
import org.abego.stringgraph.internal.commons.StringUtil;

public final class EdgeUtil {
    private static final Comparator<Edge> COMPARATOR = EdgeUtil.createComparator();
    private static final Comparator<Edge> COMPARATOR_LABEL_LAST = EdgeUtil.createComparatorLabelLast();

    EdgeUtil() {
        throw new UnsupportedOperationException();
    }

    public static Comparator<Edge> getComparator() {
        return COMPARATOR;
    }

    public static Comparator<Edge> getComparatorLabelLast() {
        return COMPARATOR_LABEL_LAST;
    }

    public static String calcEdgeText(Edge edge) {
        StringBuilder sb = new StringBuilder();
        sb.append(edge.getFromNode().getText());
        String label = edge.getLabel();
        if (!label.isEmpty()) {
            sb.append(" --");
            sb.append(StringUtil.quotedIfNeeded(label));
            sb.append("--> ");
        } else {
            sb.append(" --> ");
        }
        sb.append(edge.getToNode().getText());
        return sb.toString();
    }

    private static Comparator<Edge> createComparator() {
        return Comparator.comparing(Edge::getFromNode).thenComparing(Edge::getLabel).thenComparing(Edge::getToNode);
    }

    private static Comparator<Edge> createComparatorLabelLast() {
        return Comparator.comparing(Edge::getFromNode).thenComparing(Edge::getToNode).thenComparing(Edge::getLabel);
    }
}

