/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.net.URI;
import java.util.function.Function;
import org.abego.stringgraph.core.StringGraph;
import org.abego.stringgraph.core.StringGraphBuilder;
import org.abego.stringgraph.core.StringGraphConstructing;
import org.abego.stringgraph.core.StringGraphDump;
import org.abego.stringgraph.core.StringGraphs;
import org.abego.stringgraph.internal.StringGraphBuilderImpl;
import org.abego.stringgraph.internal.StringGraphDumpImpl;
import org.abego.stringgraph.internal.StringGraphStoreDefault;

public class StringGraphsImpl
implements StringGraphs {
    private static final StringGraphs INSTANCE = new StringGraphsImpl();

    public static StringGraphs getInstance() {
        return INSTANCE;
    }

    @Override
    public StringGraphBuilder createStringGraphBuilder() {
        return StringGraphBuilderImpl.createStringGraphBuilder();
    }

    @Override
    public void writeStringGraph(StringGraph stringGraph, URI uri) {
        StringGraphStoreDefault store = StringGraphStoreDefault.createStringGraphStoreDefault(uri);
        store.writeStringGraph(stringGraph);
    }

    @Override
    public StringGraph readStringGraph(URI uri) {
        StringGraphStoreDefault store = StringGraphStoreDefault.createStringGraphStoreDefault(uri);
        return store.readStringGraph();
    }

    @Override
    public void constructStringGraph(URI uri, StringGraphConstructing constructing) {
        StringGraphStoreDefault store = StringGraphStoreDefault.createStringGraphStoreDefault(uri);
        store.constructStringGraph(constructing);
    }

    @Override
    public StringGraphDump createStringGraphDump(StringGraph graph, Function<String, String> idOrLabelToText) {
        return StringGraphDumpImpl.createStringGraphDump(graph, idOrLabelToText);
    }

    @Override
    public StringGraphDump createStringGraphDump(StringGraph graph) {
        return StringGraphDumpImpl.createStringGraphDump(graph);
    }
}

