/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.abego.stringgraph.internal.DataFormatVersion;
import org.abego.stringgraph.internal.StringGraphStoreException;

class StringGraphStoreUtil {
    StringGraphStoreUtil() {
    }

    static void readAndCheckDataFormat(ObjectInputStream objectInputStream, String dataFormatName, DataFormatVersion supportedVersion) {
        DataFormatVersion version = StringGraphStoreUtil.readDataFormatVersion(objectInputStream, dataFormatName);
        if (version.majorNumber != supportedVersion.majorNumber) {
            throw new StringGraphStoreException(String.format("Incompatible data format version. Expected '%d', got '%d'", supportedVersion.majorNumber, version.majorNumber));
        }
    }

    public static void writeDataFormat(ObjectOutputStream objectOutputStream, String dataFormatName, DataFormatVersion dataFormatVersion) {
        try {
            objectOutputStream.writeObject(dataFormatName);
            objectOutputStream.writeInt(dataFormatVersion.majorNumber);
            objectOutputStream.writeInt(dataFormatVersion.minorNumber);
        }
        catch (IOException e) {
            throw new StringGraphStoreException("Error when writing data format", e);
        }
    }

    private static DataFormatVersion readDataFormatVersion(ObjectInputStream objectInputStream, String dataFormatName) {
        String formatName = StringGraphStoreUtil.readFormatName(objectInputStream);
        if (!formatName.equals(dataFormatName)) {
            throw new StringGraphStoreException(String.format("Invalid file format. Expected header '%s', got '%s'", dataFormatName, formatName));
        }
        try {
            int major = objectInputStream.readInt();
            int minor = objectInputStream.readInt();
            return DataFormatVersion.createDataFormatVersion(major, minor);
        }
        catch (Exception e) {
            throw new StringGraphStoreException("Error when reading data format", e);
        }
    }

    private static String readFormatName(ObjectInputStream objectInputStream) {
        try {
            return (String)objectInputStream.readObject();
        }
        catch (Exception e) {
            throw new StringGraphStoreException("Error when reading data format name", e);
        }
    }
}

