/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.abego.stringgraph.core.Edge;
import org.abego.stringgraph.core.Edges;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.core.Nodes;
import org.abego.stringgraph.core.Properties;
import org.abego.stringgraph.core.Property;
import org.abego.stringgraph.core.StringGraph;
import org.abego.stringgraph.core.StringGraphConstructing;
import org.abego.stringgraph.internal.DataFormatVersion;
import org.abego.stringgraph.internal.StringGraphImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.StringGraphStateImpl;
import org.abego.stringgraph.internal.StringGraphStore;
import org.abego.stringgraph.internal.StringGraphStoreException;
import org.abego.stringgraph.internal.StringGraphStoreUtil;
import org.abego.stringgraph.internal.commons.FileUtil;
import org.abego.stringgraph.internal.commons.VLQUtil;
import org.abego.stringpool.StringPool;
import org.abego.stringpool.StringPoolBuilder;
import org.abego.stringpool.StringPools;

class StringGraphStoreDefault
implements StringGraphStore {
    private final URI uri;
    private static final String DATA_FORMAT_NAME = "org.abego.stringgraph.store.StringGraphStoreDefault";
    private static final DataFormatVersion DATA_FORMAT_VERSION = DataFormatVersion.createDataFormatVersion(1, 0);
    private static final String NODES_TAG = "nodes";
    private static final String EDGES_TAG = "edges";
    private static final String NODE_PROPERTIES_TAG = "node-properties";
    private static final String END_TAG = "end";

    private StringGraphStoreDefault(URI uri) {
        this.uri = uri;
    }

    static StringGraphStoreDefault createStringGraphStoreDefault(URI uri) {
        return new StringGraphStoreDefault(uri);
    }

    @Override
    public void writeStringGraph(StringGraph stringGraph) {
        File file = new File(this.uri);
        FileUtil.ensureDirectoryExists(file.getParentFile());
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            this.writeGraphToStream(objectOutputStream, stringGraph);
        }
        catch (Exception e) {
            throw new StringGraphStoreException(String.format("Error when writing graph to %s: %s", this.uri, e.getMessage()), e);
        }
    }

    @Override
    public void constructStringGraph(StringGraphConstructing graphConstructing) {
        StringGraphState state = this.readStringGraphState();
        state.constructGraph(graphConstructing);
    }

    @Override
    public StringGraph readStringGraph() {
        StringGraphState state = this.readStringGraphState();
        return StringGraphImpl.createStringGraph(state);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringGraphState readStringGraphState() {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(this.uri.toURL().openStream());){
            StringGraphState stringGraphState = this.readStringGraphStateFromStream(objectInputStream);
            return stringGraphState;
        }
        catch (Exception e) {
            throw new StringGraphStoreException(String.format("Error when reading graph from %s: %s", this.uri, e.getMessage()), e);
        }
    }

    public static String getDataFormatName() {
        return DATA_FORMAT_NAME;
    }

    public static DataFormatVersion getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    void writeGraphToStream(ObjectOutputStream objectOutputStream, StringGraph stringGraph) {
        GraphWriter graphWriter = new GraphWriter(objectOutputStream, stringGraph);
        graphWriter.write();
    }

    StringGraphState readStringGraphStateFromStream(ObjectInputStream objectInputStream) {
        StringGraphStoreUtil.readAndCheckDataFormat(objectInputStream, StringGraphStoreDefault.getDataFormatName(), DATA_FORMAT_VERSION);
        HashMap<Integer, int[]> props = new HashMap();
        int[] nodesIDs = new int[]{};
        int[] edgesIDs = new int[]{};
        while (true) {
            String tag;
            switch (tag = this.readTag(objectInputStream)) {
                case "nodes": {
                    nodesIDs = this.readNodesBlock(objectInputStream);
                    break;
                }
                case "edges": {
                    edgesIDs = this.readEdgesBlock(objectInputStream);
                    break;
                }
                case "node-properties": {
                    props = this.readNodePropertiesBlock(objectInputStream);
                    break;
                }
                case "end": {
                    StringPool strings = this.readEndBlock(objectInputStream);
                    return new StringGraphStateImpl(props, nodesIDs, edgesIDs, strings);
                }
            }
        }
    }

    private int[] readNodesBlock(ObjectInputStream objectInputStream) {
        int n = this.readInt(objectInputStream);
        int[] nodesIDs = new int[n];
        for (int i = 0; i < n; ++i) {
            nodesIDs[i] = this.readInt(objectInputStream);
        }
        return nodesIDs;
    }

    private int[] readEdgesBlock(ObjectInputStream objectInputStream) {
        int n = this.readInt(objectInputStream);
        int size = n * 3;
        int[] edgesIDs = new int[size];
        for (int i = 0; i < size; i += 3) {
            edgesIDs[i] = this.readInt(objectInputStream);
            edgesIDs[i + 1] = this.readInt(objectInputStream);
            edgesIDs[i + 2] = this.readInt(objectInputStream);
        }
        return edgesIDs;
    }

    private Map<Integer, int[]> readNodePropertiesBlock(ObjectInputStream objectInputStream) {
        HashMap<Integer, int[]> props = new HashMap<Integer, int[]>();
        int countOfNodesWithProps = this.readInt(objectInputStream);
        for (int iNode = 0; iNode < countOfNodesWithProps; ++iNode) {
            int nodeID = this.readInt(objectInputStream);
            int nProps = this.readInt(objectInputStream);
            int[] propsIDs = new int[nProps * 2];
            for (int i = 0; i < nProps; ++i) {
                propsIDs[2 * i] = this.readInt(objectInputStream);
                propsIDs[2 * i + 1] = this.readInt(objectInputStream);
            }
            props.put(nodeID, propsIDs);
        }
        return props;
    }

    private StringPool readEndBlock(ObjectInputStream objectInputStream) {
        int len = this.readInt(objectInputStream);
        byte[] bytes = StringGraphStoreDefault.readBytes(objectInputStream, len);
        return StringPools.newStringPool((byte[])bytes);
    }

    String readTag(ObjectInputStream objectInputStream) {
        try {
            return (String)objectInputStream.readObject();
        }
        catch (Exception e) {
            throw new StringGraphStoreException("Error when reading block tag", e);
        }
    }

    int readInt(ObjectInputStream objectInputStream) {
        return StringGraphStoreDefault.readVLQInt(objectInputStream);
    }

    private static byte[] readBytes(ObjectInputStream objectInputStream, int len) {
        try {
            byte[] bytes = new byte[len];
            objectInputStream.readFully(bytes);
            return bytes;
        }
        catch (Exception e) {
            throw new StringGraphStoreException("Error when reading bytes", e);
        }
    }

    private static int readVLQInt(ObjectInputStream objectInputStream) {
        return VLQUtil.decodeUnsignedIntFromVLQ(() -> {
            try {
                return objectInputStream.readByte();
            }
            catch (Exception e) {
                throw new StringGraphStoreException("Error when reading VLQ 'int'", e);
            }
        });
    }

    private int calcCountOfNodesWithProps(StringGraph stringGraph) {
        int result = 0;
        for (Node node : stringGraph.nodes()) {
            if (stringGraph.getNodeProperties(node.id()).getSize() <= 0) continue;
            ++result;
        }
        return result;
    }

    private class GraphWriter {
        private final StringPoolBuilder builder = StringPools.builder();
        private final ObjectOutputStream objectOutputStream;
        private final StringGraph stringGraph;

        private GraphWriter(ObjectOutputStream objectOutputStream, StringGraph stringGraph) {
            this.objectOutputStream = objectOutputStream;
            this.stringGraph = stringGraph;
        }

        public void write() {
            StringGraphStoreUtil.writeDataFormat(this.objectOutputStream, StringGraphStoreDefault.getDataFormatName(), DATA_FORMAT_VERSION);
            this.writeTag(StringGraphStoreDefault.EDGES_TAG);
            this.writeEdgesBlock();
            this.writeTag(StringGraphStoreDefault.NODES_TAG);
            this.writeNodesBlock();
            this.writeTag(StringGraphStoreDefault.NODE_PROPERTIES_TAG);
            this.writeNodePropertiesBlock();
            this.writeTag(StringGraphStoreDefault.END_TAG);
            this.writeEndBlock();
        }

        private void writeEdgesBlock() {
            Edges allEdges = this.stringGraph.edges();
            this.writeInt(allEdges.getSize());
            for (Edge e : allEdges) {
                this.writeString(e.getFromNode().id());
                this.writeString(e.getToNode().id());
                this.writeString(e.getLabel());
            }
        }

        private boolean writeSortedNodes() {
            return true;
        }

        private List<Node> nodesSortedById(Nodes nodes) {
            return ((Stream)nodes.stream().parallel()).sorted(Comparator.comparing(Node::id)).collect(Collectors.toList());
        }

        private void writeNodesBlock() {
            Nodes allNodes = this.stringGraph.nodes();
            this.writeInt(allNodes.getSize());
            Nodes nodesToWrite = this.writeSortedNodes() ? this.nodesSortedById(allNodes) : allNodes;
            for (Node s : nodesToWrite) {
                this.writeString(s.id());
            }
        }

        private void writeNodePropertiesBlock() {
            this.writeInt(StringGraphStoreDefault.this.calcCountOfNodesWithProps(this.stringGraph));
            Nodes allNodes = this.stringGraph.nodes();
            for (Node node : allNodes) {
                Properties properties = this.stringGraph.getNodeProperties(node.id());
                int n = properties.getSize();
                if (n <= 0) continue;
                this.writeString(node.id());
                this.writeInt(n);
                for (Property p : properties) {
                    this.writeString(p.getName());
                    this.writeString(p.getValue());
                }
            }
        }

        void writeEndBlock() {
            StringPool allStrings = this.builder.build();
            byte[] bytes = allStrings.getBytes();
            this.writeVLQInt(bytes.length);
            try {
                for (byte b : bytes) {
                    this.objectOutputStream.writeByte(b);
                }
            }
            catch (Exception e) {
                throw new StringGraphStoreException("Error when writing end block", e);
            }
        }

        private void writeInt(int i) {
            this.writeVLQInt(i);
        }

        void writeTag(String tag) {
            try {
                this.objectOutputStream.writeObject(tag);
            }
            catch (Exception e) {
                throw new StringGraphStoreException("Error when writing block tag", e);
            }
        }

        private void writeString(String s) {
            this.writeVLQInt(this.builder.add(s));
        }

        private void writeVLQInt(int i) {
            VLQUtil.encodeUnsignedIntAsVLQ(i, val -> {
                try {
                    this.objectOutputStream.writeByte(val);
                }
                catch (Exception e) {
                    throw new StringGraphStoreException("Error when writing VLQ 'int'", e);
                }
            });
        }
    }
}

