/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.ArrayUtil;
import org.abego.stringpool.StringPool;
import org.eclipse.jdt.annotation.Nullable;

class StringGraphStateImpl
implements StringGraphState {
    private final Map<Integer, int[]> props;
    private final int[] nodesIDs;
    private final int[] edgesIDs;
    private final StringPool strings;
    private final Map<Integer, String> cachedStrings = new HashMap<Integer, String>();
    private @Nullable Map<String, Integer> stringIds;

    public StringGraphStateImpl(Map<Integer, int[]> props, int[] nodesIDs, int[] edgesIDs, StringPool strings) {
        this.props = props;
        this.nodesIDs = nodesIDs;
        this.edgesIDs = edgesIDs;
        this.strings = strings;
    }

    @Override
    public int[] getNodesIds() {
        return this.nodesIDs;
    }

    @Override
    public int getFromId(int edgesOffset) {
        return this.edgesIDs[edgesOffset];
    }

    @Override
    public int getToId(int edgesOffset) {
        return this.edgesIDs[edgesOffset + 1];
    }

    @Override
    public int getLabelId(int edgesOffset) {
        return this.edgesIDs[edgesOffset + 2];
    }

    @Override
    public int getEdgesCount() {
        return this.edgesIDs.length / 3;
    }

    @Override
    public int @Nullable [] getPropertyDataForNode(int id) {
        return this.props.get(id);
    }

    @Override
    public int[] getNodesWithProperties() {
        return ArrayUtil.intArray(this.props.keySet());
    }

    @Override
    public String getString(int id) {
        return this.cachedStrings.computeIfAbsent(id, arg_0 -> ((StringPool)this.strings).getString(arg_0));
    }

    @Override
    public int getStringId(String stringText) {
        int id = this.getStringIdOrZero(stringText);
        if (id == 0) {
            throw new NoSuchElementException();
        }
        return id;
    }

    @Override
    public int getStringIdOrZero(String stringText) {
        Integer result = this.getStringIds().get(stringText);
        return result != null ? result : 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringGraphStateImpl that = (StringGraphStateImpl)o;
        return this.props.equals(that.props) && Arrays.equals(this.nodesIDs, that.nodesIDs) && Arrays.equals(this.edgesIDs, that.edgesIDs) && this.strings.equals(that.strings);
    }

    public int hashCode() {
        int result = Objects.hash(this.props, this.strings);
        result = 31 * result + Arrays.hashCode(this.nodesIDs);
        result = 31 * result + Arrays.hashCode(this.edgesIDs);
        return result;
    }

    private Map<String, Integer> getStringIds() {
        if (this.stringIds == null) {
            this.stringIds = new HashMap<String, Integer>();
            for (StringPool.StringAndID e : this.strings.allStringAndIDs()) {
                this.stringIds.put(e.getString(), e.getID());
            }
        }
        return this.stringIds;
    }
}

