/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.abego.stringgraph.core.Edge;
import org.abego.stringgraph.core.EdgeLabels;
import org.abego.stringgraph.core.Edges;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.core.Nodes;
import org.abego.stringgraph.core.Properties;
import org.abego.stringgraph.core.Property;
import org.abego.stringgraph.core.StringGraph;
import org.abego.stringgraph.core.exception.StringGraphException;
import org.abego.stringgraph.internal.EdgeLabelsImpl;
import org.abego.stringgraph.internal.EdgesImpl;
import org.abego.stringgraph.internal.EdgesIndex;
import org.abego.stringgraph.internal.EmptyEdges;
import org.abego.stringgraph.internal.EmptyNodes;
import org.abego.stringgraph.internal.NodeImpl;
import org.abego.stringgraph.internal.NodesImpl;
import org.abego.stringgraph.internal.PropertiesImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.StringUtil;
import org.eclipse.jdt.annotation.Nullable;

class StringGraphImpl
implements StringGraph {
    private final Properties emptyProperties;
    private final StringGraphState state;
    private final Set<Integer> nodeIds;
    private final EdgesIndex edgesIndexForFromNode;
    private final EdgesIndex edgesIndexForToNode;
    private final EdgesIndex edgesIndexForLabel;
    private @Nullable Nodes fromNodes;
    private @Nullable Nodes toNodes;

    private StringGraphImpl(StringGraphState state) {
        this.state = state;
        this.emptyProperties = new PropertiesImpl(new int[0], state);
        this.nodeIds = new HashSet<Integer>();
        for (int i : state.getNodesIds()) {
            this.nodeIds.add(i);
        }
        this.edgesIndexForFromNode = new EdgesIndex(state);
        this.edgesIndexForToNode = new EdgesIndex(state);
        this.edgesIndexForLabel = new EdgesIndex(state);
        int edgesCount = state.getEdgesCount();
        for (int i = 0; i < edgesCount; ++i) {
            int edgeId = i * 3;
            this.edgesIndexForFromNode.add(state.getFromId(edgeId), edgeId);
            this.edgesIndexForToNode.add(state.getToId(edgeId), edgeId);
            this.edgesIndexForLabel.add(state.getLabelId(edgeId), edgeId);
        }
    }

    public static StringGraph createStringGraph(StringGraphState data) {
        return new StringGraphImpl(data);
    }

    @Override
    public Nodes fromNodes() {
        if (this.fromNodes == null) {
            this.fromNodes = new NodesImpl(this.edgesIndexForFromNode.keys(), this.state);
        }
        return this.fromNodes;
    }

    @Override
    public Nodes nodes() {
        return new NodesImpl(this.state.getNodesIds(), this.state);
    }

    @Override
    public Nodes nodes(@Nullable String fromPattern, @Nullable String labelPattern, @Nullable String toPattern) {
        PatternKind fromKind = PatternKind.of(fromPattern);
        PatternKind labelKind = PatternKind.of(labelPattern);
        PatternKind toKind = PatternKind.of(toPattern);
        if (fromKind != PatternKind.QUERY && toKind != PatternKind.QUERY) {
            throw new StringGraphException("Either `from` or `to` (or both) must be queried ('?')");
        }
        int combinationIndex = fromKind.ordinal() + 3 * labelKind.ordinal() + 9 * toKind.ordinal();
        switch (combinationIndex) {
            case 24: {
                return this.fromNodes();
            }
            case 8: {
                return this.toNodes();
            }
            case 6: {
                return this.nodes();
            }
            case 15: {
                return this.nodesToNode(toPattern);
            }
            case 7: {
                return this.nodesFromNode(fromPattern);
            }
            case 12: {
                return this.nodesViaEdgeLabeledToNode(labelPattern, toPattern);
            }
            case 4: {
                return this.nodesFromNodeViaEdgeLabeled(fromPattern, labelPattern);
            }
            case 21: {
                return this.asNodes(this.edgesIndexForLabel.edges(labelPattern).stream().map(Edge::getFromNode).collect(Collectors.toSet()));
            }
            case 5: {
                return this.asNodes(this.edgesIndexForLabel.edges(labelPattern).stream().map(Edge::getToNode).collect(Collectors.toSet()));
            }
            case 3: {
                HashSet<Node> nodes = new HashSet<Node>();
                this.edgesIndexForLabel.edges(labelPattern).forEach(edge -> {
                    nodes.add(edge.getFromNode());
                    nodes.add(edge.getToNode());
                });
                return this.asNodes(nodes);
            }
        }
        throw new StringGraphException(String.format("Unsupported query: (%s, %s, %s)", StringUtil.quoted2(fromPattern), StringUtil.quoted2(labelPattern), StringUtil.quoted2(toPattern)));
    }

    @Override
    public Edges edges() {
        int[] result = new int[this.state.getEdgesCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i * 3;
        }
        return new EdgesImpl(result, this.state);
    }

    @Override
    public Edges edges(@Nullable String from, @Nullable String label, @Nullable String to) {
        ArrayList<Edges> edgesByPart = new ArrayList<Edges>();
        if (from != null) {
            if (!this.hasNode(from)) {
                return EmptyEdges.EMPTY_EDGES;
            }
            edgesByPart.add(this.edgesFromNode(from));
        }
        if (label != null) {
            edgesByPart.add(this.edgesLabeled(label));
        }
        if (to != null) {
            if (!this.hasNode(to)) {
                return EmptyEdges.EMPTY_EDGES;
            }
            edgesByPart.add(this.edgesToNode(to));
        }
        if (edgesByPart.isEmpty()) {
            return this.edges();
        }
        Edges result = (Edges)edgesByPart.get(0);
        for (int i = 1; i < edgesByPart.size(); ++i) {
            result = result.intersected((Edges)edgesByPart.get(i));
        }
        return result;
    }

    @Override
    public Properties getNodeProperties(String node) {
        return this.getNodeProperties().apply(node);
    }

    @Override
    public boolean hasNodeProperty(String node, String propertyName) {
        return this.getNodeProperties(node).hasProperty(propertyName);
    }

    @Override
    public Property getNodeProperty(String node, String propertyName) {
        return this.getNodeProperties(node).getProperty(propertyName);
    }

    @Override
    public String getNodePropertyValue(String node, String propertyName) {
        return this.getNodeProperty(node, propertyName).getValue();
    }

    @Override
    public String getNodePropertyValueOrElse(String node, String propertyName, String defaultValue) {
        return this.hasNode(node) ? this.getNodeProperties(node).getValueOfPropertyOrElse(propertyName, defaultValue) : defaultValue;
    }

    @Override
    public Nodes toNodes() {
        if (this.toNodes == null) {
            this.toNodes = new NodesImpl(this.edgesIndexForToNode.keys(), this.state);
        }
        return this.toNodes;
    }

    @Override
    public EdgeLabels edgeLabels() {
        return EdgeLabelsImpl.createEdgeLabels(this.edgesIndexForLabel.keyStrings());
    }

    @Override
    public Nodes nodesFromNode(String fromNode) {
        return this.selectNodes(fromNode, this.edgesIndexForFromNode::edges, e -> true, Edge::getToNode);
    }

    @Override
    public EdgeLabels edgeLabelsFromNode(String fromNode) {
        return this.valueWithNodeOrElse(fromNode, n -> EdgeLabelsImpl.createEdgeLabels(this.edgesIndexForFromNode.edges((Node)n).stream().map(Edge::getLabel).collect(Collectors.toSet())), EdgeLabelsImpl.EMPTY_EDGE_LABELS);
    }

    @Override
    public Nodes nodesFromNodeViaEdgeLabeled(String fromNode, String edgeLabel) {
        return this.selectNodes(fromNode, this.edgesIndexForFromNode::edges, e -> e.getLabel().equals(edgeLabel), Edge::getToNode);
    }

    @Override
    public Nodes nodesToNode(String toNode) {
        return this.selectNodes(toNode, this.edgesIndexForToNode::edges, e -> true, Edge::getFromNode);
    }

    @Override
    public EdgeLabels edgeLabelsToNode(String toNode) {
        return this.valueWithNodeOrElse(toNode, n -> EdgeLabelsImpl.createEdgeLabels(this.edgesIndexForToNode.edges((Node)n).stream().map(Edge::getLabel).collect(Collectors.toSet())), EdgeLabelsImpl.EMPTY_EDGE_LABELS);
    }

    @Override
    public Nodes nodesViaEdgeLabeledToNode(String edgeLabel, String toNode) {
        try {
            Edges edges = this.edgesIndexForToNode.edges(toNode);
            return this.fromNodeOfEdgesWithLabel(edges, edgeLabel);
        }
        catch (NoSuchElementException e) {
            return EmptyNodes.EMPTY_NODES;
        }
    }

    @Override
    public Edges edgesWith(Predicate<Edge> edgePredicate) {
        return this.edges().filtered(edgePredicate);
    }

    @Override
    public Edges edgesLabeled(String edgeLabel) {
        return this.edgesIndexForLabel.edges(edgeLabel);
    }

    @Override
    public Edges edgesFromNode(String fromNode) {
        return this.valueWithNodeOrElse(fromNode, this.edgesIndexForFromNode::edges, EmptyEdges.EMPTY_EDGES);
    }

    @Override
    public Edges edgesToNode(String toNode) {
        return this.valueWithNodeOrElse(toNode, this.edgesIndexForToNode::edges, EmptyEdges.EMPTY_EDGES);
    }

    @Override
    public boolean hasEdge(String fromNode, String edgeLabel, String toNode) {
        return this.edges().contains(fromNode, edgeLabel, toNode);
    }

    public String toString() {
        return "StringGraphImpl{state=" + this.state + '}';
    }

    public Function<String, Properties> getNodeProperties() {
        return nodeId -> {
            int id = this.state.getStringId((String)nodeId);
            int[] ps = this.state.getPropertyDataForNode(id);
            if (ps == null) {
                return this.emptyProperties;
            }
            return new PropertiesImpl(ps, this.state);
        };
    }

    public Node getNode(String id) {
        int stringId = this.state.getStringId(id);
        if (!this.nodeIds.contains(stringId)) {
            throw new NoSuchElementException();
        }
        return new NodeImpl(stringId, this.state);
    }

    public Nodes fromNodeOfEdgesWithLabel(Edges edges, String edgeLabel) {
        int edgesSize = edges.getSize();
        int labelId = this.state.getStringIdOrZero(edgeLabel);
        if (labelId == 0 || edgesSize == 0) {
            return EmptyNodes.EMPTY_NODES;
        }
        int[] buffer = new int[edgesSize];
        int i = 0;
        for (int id : EdgesImpl.asEdgesImpl(edges).edgesIds()) {
            if (this.state.getLabelId(id) != labelId) continue;
            buffer[i++] = this.state.getFromId(id);
        }
        return new NodesImpl(Arrays.copyOf(buffer, i), this.state);
    }

    private Nodes asNodes(Set<Node> nodes) {
        if (nodes.isEmpty()) {
            return EmptyNodes.EMPTY_NODES;
        }
        int[] nodesIDs = nodes.stream().mapToInt(e -> NodeImpl.asNodeImpl(e).idAsInt()).toArray();
        return new NodesImpl(nodesIDs, this.state);
    }

    @Override
    public boolean hasNode(String id) {
        int stringId = this.state.getStringIdOrZero(id);
        return stringId != 0 && this.nodeIds.contains(stringId);
    }

    private Nodes selectNodes(String nodeId, Function<Node, Edges> edgesProvider, Predicate<Edge> edgeCondition, Function<Edge, Node> nodeSelect) {
        return this.valueWithNodeOrElse(nodeId, n -> this.asNodes(((Edges)edgesProvider.apply((Node)n)).stream().filter(edgeCondition).map(nodeSelect).collect(Collectors.toSet())), EmptyNodes.EMPTY_NODES);
    }

    private <T> T valueWithNodeOrElse(String nodeId, Function<Node, T> function, T elseValue) {
        return this.hasNode(nodeId) ? function.apply(this.getNode(nodeId)) : elseValue;
    }

    private static enum PatternKind {
        QUERY,
        BOUND,
        NULL;


        static PatternKind of(@Nullable String pattern) {
            return pattern == null ? NULL : (pattern.startsWith("?") ? QUERY : BOUND);
        }
    }
}

