/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.abego.stringgraph.core.Edge;
import org.abego.stringgraph.core.Edges;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.core.Nodes;
import org.abego.stringgraph.core.Properties;
import org.abego.stringgraph.core.StringGraph;
import org.abego.stringgraph.core.StringGraphDump;
import org.abego.stringgraph.internal.commons.StringUtil;

public class StringGraphDumpImpl
implements StringGraphDump {
    private final StringGraph graph;
    private final Function<String, String> idToText;

    private StringGraphDumpImpl(StringGraph graph, Function<String, String> idToText) {
        this.graph = graph;
        this.idToText = idToText;
    }

    public static StringGraphDump createStringGraphDump(StringGraph graph, Function<String, String> idToText) {
        return new StringGraphDumpImpl(graph, idToText);
    }

    public static StringGraphDump createStringGraphDump(StringGraph graph) {
        return new StringGraphDumpImpl(graph, Function.identity());
    }

    @Override
    public void write(PrintWriter writer) {
        Nodes nodes = this.graph.nodes();
        Comparator nodeComparator = (a, b) -> StringUtil.compareToIgnoreCaseStable(StringGraphDumpImpl.text(a, this.idToText), StringGraphDumpImpl.text(b, this.idToText));
        nodes.stream().sorted(nodeComparator).forEach(fromNode -> {
            Edges edges = this.graph.edgesFromNode(fromNode.id());
            int edgeCount = edges.getSize();
            String fromNodeText = StringGraphDumpImpl.text(fromNode, this.idToText);
            if (edgeCount == 0) {
                writer.println(fromNodeText + this.propertiesText((Node)fromNode) + " .");
            } else if (edgeCount == 1) {
                Edge edge2 = (Edge)edges.iterator().next();
                writer.println(fromNodeText + this.propertiesText((Node)fromNode) + " " + StringGraphDumpImpl.labeltext(edge2, this.idToText) + " " + StringGraphDumpImpl.text(edge2.getToNode(), this.idToText) + " .");
            } else {
                writer.println(fromNodeText + this.propertiesText((Node)fromNode));
                Comparator edgeComparator = (a, b) -> {
                    String lb;
                    String la = StringGraphDumpImpl.labeltext(a, this.idToText);
                    int r = StringUtil.compareToIgnoreCaseStable(la, lb = StringGraphDumpImpl.labeltext(b, this.idToText));
                    return r != 0 ? r : StringUtil.compareToIgnoreCaseStable(StringGraphDumpImpl.text(a.getToNode(), this.idToText), StringGraphDumpImpl.text(b.getToNode(), this.idToText));
                };
                int[] i = new int[]{0};
                edges.stream().sorted(edgeComparator).forEach(edge -> {
                    i[0] = i[0] + 1;
                    writer.println("\t" + StringGraphDumpImpl.labeltext(edge, this.idToText) + " " + StringGraphDumpImpl.text(edge.getToNode(), this.idToText) + (i[0] < edgeCount ? " ;" : " ."));
                });
            }
        });
    }

    private static String text(Node node, Function<String, String> idTranslation) {
        return StringUtil.quotedIfNeeded(idTranslation.apply(node.id()));
    }

    private static String labeltext(Edge edge, Function<String, String> labelToText) {
        return StringUtil.quotedIfNeeded(labelToText.apply(edge.getLabel()));
    }

    private String propertiesText(Node node) {
        Properties props = this.graph.getNodeProperties(node.id());
        return props.getSize() == 0 ? "" : "{" + props.propertyNames().sorted().map(props::getProperty).map(p -> p.getName() + ": " + p.getValue()).collect(Collectors.joining(", ")) + "}";
    }
}

