/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.abego.stringgraph.core.StringGraph;
import org.abego.stringgraph.core.StringGraphBuilder;
import org.abego.stringgraph.core.exception.StringGraphException;
import org.abego.stringgraph.internal.StringGraphImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.StringGraphStateImpl;
import org.abego.stringgraph.internal.commons.ArrayUtil;
import org.abego.stringpool.StringPool;
import org.abego.stringpool.StringPoolBuilder;
import org.abego.stringpool.StringPools;
import org.eclipse.jdt.annotation.Nullable;

final class StringGraphBuilderImpl
implements StringGraphBuilder {
    private final StringPoolBuilder stringPoolBuilder = StringPools.builder();
    private final Set<Integer> nodes = new HashSet<Integer>();
    private final Set<EdgeData> edges = new HashSet<EdgeData>();
    private final Map<Integer, Map<Integer, Integer>> nodeProperties = new HashMap<Integer, Map<Integer, Integer>>();

    private StringGraphBuilderImpl() {
    }

    public static StringGraphBuilder createStringGraphBuilder() {
        return new StringGraphBuilderImpl();
    }

    @Override
    public void addNode(String node) {
        this.nodes.add(this.stringPoolBuilder.add(node));
    }

    @Override
    public void addEdge(String fromNode, String edgeLabel, String toNode) {
        int fromId = this.stringPoolBuilder.add(fromNode);
        int toId = this.stringPoolBuilder.add(toNode);
        int labelId = this.stringPoolBuilder.add(edgeLabel);
        this.nodes.add(fromId);
        this.nodes.add(toId);
        this.edges.add(new EdgeData(fromId, toId, labelId));
    }

    @Override
    public void setNodeProperty(String node, String name, String value) {
        if (!this.stringPoolBuilder.contains(node)) {
            throw new StringGraphException(String.format("Error when setting node property. Node does not exist: %s", node));
        }
        this.nodeProperties.computeIfAbsent(this.stringPoolBuilder.add(node), k -> new HashMap()).put(this.stringPoolBuilder.add(name), this.stringPoolBuilder.add(value));
    }

    @Override
    public StringGraph build() {
        StringGraphState state = this.buildStringGraphState();
        return StringGraphImpl.createStringGraph(state);
    }

    public StringGraphState buildStringGraphState() {
        int[] nodesIds = ArrayUtil.toIntArray(this.nodes);
        int[] edgesIds = StringGraphBuilderImpl.toFlatIntArray(this.edges);
        Map<Integer, int[]> props = StringGraphBuilderImpl.toIntegerIntArrayMap(this.nodeProperties);
        StringPool strings = this.stringPoolBuilder.build();
        return new StringGraphStateImpl(props, nodesIds, edgesIds, strings);
    }

    private static int[] toFlatIntArray(Collection<EdgeData> edgeDataCollection) {
        int count = edgeDataCollection.size();
        int[] result = new int[count * 3];
        int offset = 0;
        for (EdgeData e : edgeDataCollection) {
            result[offset++] = e.fromId;
            result[offset++] = e.toId;
            result[offset++] = e.labelId;
        }
        return result;
    }

    private static Map<Integer, int[]> toIntegerIntArrayMap(Map<Integer, Map<Integer, Integer>> integerMapMap) {
        HashMap<Integer, int[]> props = new HashMap<Integer, int[]>();
        for (Map.Entry<Integer, Map<Integer, Integer>> e : integerMapMap.entrySet()) {
            Set<Map.Entry<Integer, Integer>> ps = e.getValue().entrySet();
            int[] array = new int[ps.size() * 2];
            int offset = 0;
            for (Map.Entry<Integer, Integer> e2 : ps) {
                array[offset++] = e2.getKey();
                array[offset++] = e2.getValue();
            }
            props.put(e.getKey(), array);
        }
        return props;
    }

    private static class EdgeData {
        final int fromId;
        final int toId;
        final int labelId;

        EdgeData(int fromId, int toId, int labelId) {
            this.fromId = fromId;
            this.toId = toId;
            this.labelId = labelId;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeData edgeData = (EdgeData)o;
            return this.fromId == edgeData.fromId && this.toId == edgeData.toId && this.labelId == edgeData.labelId;
        }

        public int hashCode() {
            return Objects.hash(this.fromId, this.toId, this.labelId);
        }
    }
}

