/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.Comparator;
import org.abego.stringgraph.core.Property;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.StringUtil;

class PropertyImpl
implements Property {
    private static final Comparator<Property> PROPERTY_COMPARATOR = Comparator.comparing(Property::getName).thenComparing(Property::getValue);
    private final int nameId;
    private final int valueId;
    private final StringGraphState state;

    public PropertyImpl(int nameId, int valueId, StringGraphState state) {
        this.nameId = nameId;
        this.valueId = valueId;
        this.state = state;
    }

    @Override
    public String getName() {
        return this.state.getString(this.nameId);
    }

    @Override
    public String getValue() {
        return this.state.getString(this.valueId);
    }

    public String toString() {
        return "PropertyImpl{name=" + StringUtil.quoted2(this.getName()) + ", value=" + StringUtil.quoted2(this.getValue()) + '}';
    }

    @Override
    public int compareTo(Property o) {
        return PROPERTY_COMPARATOR.compare(this, o);
    }
}

