/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.Iterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.abego.stringgraph.core.Properties;
import org.abego.stringgraph.core.Property;
import org.abego.stringgraph.core.exception.NoSuchPropertyException;
import org.abego.stringgraph.internal.PropertyImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.eclipse.jdt.annotation.Nullable;

class PropertiesImpl
implements Properties {
    private final int[] keyValueIds;
    private final StringGraphState state;

    public PropertiesImpl(int[] keyValueIds, StringGraphState state) {
        this.keyValueIds = keyValueIds;
        this.state = state;
    }

    @Override
    public int getSize() {
        return this.keyValueIds.length / 2;
    }

    @Override
    public Stream<Property> stream() {
        return IntStream.range(0, this.getSize()).mapToObj(i -> new PropertyImpl(this.keyValueIds[2 * i], this.keyValueIds[2 * i + 1], this.state));
    }

    @Override
    public boolean hasProperty(String name) {
        int nameId = this.state.getStringIdOrZero(name);
        return nameId != 0 && IntStream.range(0, this.getSize()).anyMatch(i -> this.keyValueIds[2 * i] == nameId);
    }

    @Override
    public @Nullable Property getPropertyOrNull(String name) {
        int nameId = this.state.getStringId(name);
        return IntStream.range(0, this.getSize()).filter(i -> this.keyValueIds[2 * i] == nameId).mapToObj(i -> new PropertyImpl(this.keyValueIds[2 * i], this.keyValueIds[2 * i + 1], this.state)).findFirst().orElse(null);
    }

    @Override
    public Property getProperty(String name) {
        Property property = this.getPropertyOrNull(name);
        if (property == null) {
            throw new NoSuchPropertyException(name);
        }
        return property;
    }

    @Override
    public String getValueOfProperty(String name) {
        return this.getProperty(name).getValue();
    }

    @Override
    public String getValueOfPropertyOrElse(String name, String defaultValue) {
        Property p = this.getPropertyOrNull(name);
        return p != null ? p.getValue() : defaultValue;
    }

    @Override
    public Iterator<Property> iterator() {
        return this.stream().iterator();
    }
}

