/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.core.Nodes;
import org.abego.stringgraph.internal.NodeImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.ClassUtil;
import org.eclipse.jdt.annotation.Nullable;

class NodesImpl
implements Nodes {
    private final int[] nodesIDs;
    private final StringGraphState state;
    private boolean isSorted = false;

    static NodesImpl asNodesImpl(@Nullable Nodes nodes) {
        if (!(nodes instanceof NodesImpl)) {
            throw new IllegalArgumentException("NodesImpl expected, got " + ClassUtil.className(nodes));
        }
        return (NodesImpl)nodes;
    }

    NodesImpl(int[] nodesIDs, StringGraphState state) {
        this.nodesIDs = nodesIDs;
        this.state = state;
    }

    @Override
    public int getSize() {
        return this.nodesIDs.length;
    }

    @Override
    public Stream<Node> stream() {
        return Arrays.stream(this.nodesIDs).mapToObj(id -> new NodeImpl(id, this.state));
    }

    @Override
    public Nodes intersected(Nodes otherNodes) {
        if (otherNodes == this) {
            return this;
        }
        int[] a = this.sortedIds();
        int[] b = NodesImpl.asNodesImpl(otherNodes).sortedIds();
        int nA = a.length;
        int nB = b.length;
        int maxResultSize = Math.min(nA, nB);
        int[] buffer = new int[maxResultSize];
        int iBuffer = 0;
        int iA = 0;
        int iB = 0;
        while (iA < nA && iB < nB) {
            int vA = a[iA];
            int vB = b[iB];
            if (vA == vB) {
                buffer[iBuffer++] = vA;
                ++iA;
                ++iB;
                continue;
            }
            if (vA > vB) {
                while (++iB < nB && vA > b[iB]) {
                }
                continue;
            }
            while (++iA < nA && vB > a[iA]) {
            }
        }
        return new NodesImpl(Arrays.copyOf(buffer, iBuffer), this.state);
    }

    @Override
    public Nodes union(Nodes otherNodes) {
        if (otherNodes == this || otherNodes.getSize() == 0) {
            return this;
        }
        if (this.getSize() == 0) {
            return otherNodes;
        }
        int[] a = this.sortedIds();
        int[] b = NodesImpl.asNodesImpl(otherNodes).sortedIds();
        int nA = a.length;
        int nB = b.length;
        int maxResultSize = nA + nB;
        int[] buffer = new int[maxResultSize];
        int iBuffer = 0;
        int iA = 0;
        int iB = 0;
        while (iA < nA && iB < nB) {
            int vA = a[iA];
            int vB = b[iB];
            if (vA == vB) {
                buffer[iBuffer++] = vA;
                ++iA;
                ++iB;
                continue;
            }
            if (vA > vB) {
                buffer[iBuffer++] = vB;
                ++iB;
                continue;
            }
            buffer[iBuffer++] = vA;
            ++iA;
        }
        while (iA < nA) {
            buffer[iBuffer++] = a[iA++];
        }
        while (iB < nB) {
            buffer[iBuffer++] = b[iB++];
        }
        return new NodesImpl(Arrays.copyOf(buffer, iBuffer), this.state);
    }

    @Override
    public Nodes filter(Predicate<Node> predicate) {
        int[] buffer = new int[this.getSize()];
        int iBuffer = 0;
        for (int id : this.nodesIDs) {
            if (!predicate.test(new NodeImpl(id, this.state))) continue;
            buffer[iBuffer++] = id;
        }
        if (iBuffer == this.getSize()) {
            return this;
        }
        return new NodesImpl(Arrays.copyOf(buffer, iBuffer), this.state);
    }

    private int[] sortedIds() {
        if (!this.isSorted) {
            Arrays.sort(this.nodesIDs);
            this.isSorted = true;
        }
        return this.nodesIDs;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.stream().iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesImpl nodes = (NodesImpl)o;
        return Arrays.equals(this.nodesIDs, nodes.nodesIDs);
    }

    public int hashCode() {
        return Arrays.hashCode(this.nodesIDs);
    }
}

