/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.ClassUtil;
import org.abego.stringgraph.internal.commons.StringUtil;
import org.eclipse.jdt.annotation.Nullable;

class NodeImpl
implements Node {
    private final int id;
    private final StringGraphState state;

    static NodeImpl asNodeImpl(@Nullable Node node) {
        if (!(node instanceof NodeImpl)) {
            throw new IllegalArgumentException("NodeImpl expected, got " + ClassUtil.className(node));
        }
        return (NodeImpl)node;
    }

    NodeImpl(int id, StringGraphState state) {
        this.id = id;
        this.state = state;
    }

    @Override
    public String id() {
        return this.state.getString(this.id);
    }

    @Override
    public String getText() {
        return StringUtil.quotedIfNeeded(this.id());
    }

    @Override
    public int compareTo(Node o) {
        if (o instanceof NodeImpl && ((NodeImpl)o).id == this.id) {
            return 0;
        }
        return this.id().compareTo(o.id());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeImpl other = (NodeImpl)o;
        return this.id == other.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "NodeImpl{id=" + StringUtil.quoted2(this.id()) + "}";
    }

    int idAsInt() {
        return this.id;
    }
}

