/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.abego.stringgraph.core.Edges;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.internal.EdgesImpl;
import org.abego.stringgraph.internal.EmptyEdges;
import org.abego.stringgraph.internal.NodeImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.ArrayUtil;

class EdgesIndex {
    private final StringGraphState state;
    private final Map<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, Edges> edgesMap = new HashMap<Integer, Edges>();

    EdgesIndex(StringGraphState state) {
        this.state = state;
    }

    public void add(int key, int edgeId) {
        this.map.computeIfAbsent(key, k -> new ArrayList()).add(edgeId);
    }

    public Edges edges(int key) {
        return key != 0 ? this.edgesMap.computeIfAbsent(key, k -> new EdgesImpl(ArrayUtil.intArray((Collection<Integer>)this.map.get(k)), this.state)) : EmptyEdges.EMPTY_EDGES;
    }

    public Edges edges(Node node) {
        return this.edges(NodeImpl.asNodeImpl(node).idAsInt());
    }

    public Edges edges(String string) {
        return this.edges(this.state.getStringIdOrZero(string));
    }

    public int[] keys() {
        return ArrayUtil.intArray(this.map.keySet());
    }

    public Set<String> keyStrings() {
        return this.map.keySet().stream().map(this.state::getString).collect(Collectors.toSet());
    }
}

