/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.abego.stringgraph.core.Edge;
import org.abego.stringgraph.core.Edges;
import org.abego.stringgraph.internal.EdgeImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.ClassUtil;
import org.abego.stringgraph.internal.commons.EdgeUtil;
import org.eclipse.jdt.annotation.Nullable;

class EdgesImpl
implements Edges {
    private final int[] edgesIds;
    private final StringGraphState state;

    static EdgesImpl asEdgesImpl(@Nullable Edges edges) {
        if (!(edges instanceof EdgesImpl)) {
            throw new IllegalArgumentException("EdgesImpl expected, got " + ClassUtil.className(edges));
        }
        return (EdgesImpl)edges;
    }

    EdgesImpl(int[] edgesIds, StringGraphState state) {
        this.edgesIds = edgesIds;
        this.state = state;
    }

    @Override
    public int getSize() {
        return this.edgesIds.length;
    }

    @Override
    public boolean contains(Edge edge) {
        int id = EdgeImpl.asEdgeImpl(edge).idAsInt();
        for (int edgesOffset : this.edgesIds) {
            if (edgesOffset != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String fromNode, String label, String toNode) {
        int fromId = this.state.getStringIdOrZero(fromNode);
        if (fromId == 0) {
            return false;
        }
        int labelId = this.state.getStringIdOrZero(label);
        if (labelId == 0) {
            return false;
        }
        int toId = this.state.getStringIdOrZero(toNode);
        if (toId == 0) {
            return false;
        }
        for (int edgesOffset : this.edgesIds) {
            if (fromId != this.state.getFromId(edgesOffset) || toId != this.state.getToId(edgesOffset) || labelId != this.state.getLabelId(edgesOffset)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<Edge> stream() {
        return Arrays.stream(this.edgesIds).mapToObj(edgesOffset -> new EdgeImpl(edgesOffset, this.state));
    }

    @Override
    public Edges filtered(Predicate<Edge> edgePredicate) {
        return this.createEdges(this.stream().filter(edgePredicate).collect(Collectors.toSet()));
    }

    private Edges createEdges(Set<Edge> edges) {
        int n = edges.size();
        int[] resultIds = new int[n];
        int i = 0;
        for (Edge edge : edges) {
            resultIds[i++] = EdgeImpl.asEdgeImpl(edge).idAsInt();
        }
        return new EdgesImpl(resultIds, this.state);
    }

    @Override
    public Edges intersected(Edges otherEdges) {
        Edges moreEdges;
        Edges fewerEdges;
        if (this.getSize() < otherEdges.getSize()) {
            fewerEdges = this;
            moreEdges = otherEdges;
        } else {
            fewerEdges = otherEdges;
            moreEdges = this;
        }
        HashSet<Edge> result = new HashSet<Edge>();
        for (Edge e : fewerEdges) {
            if (!moreEdges.contains(e)) continue;
            result.add(e);
        }
        return this.createEdges(result);
    }

    @Override
    public Iterable<Edge> sorted(Comparator<? super Edge> comparator) {
        return this.stream().sorted(comparator).collect(Collectors.toList());
    }

    @Override
    public Iterable<Edge> sorted() {
        return this.sorted(EdgeUtil.getComparator());
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.stream().iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgesImpl edges = (EdgesImpl)o;
        return Arrays.equals(this.edgesIds, edges.edgesIds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.edgesIds);
    }

    int[] edgesIds() {
        return this.edgesIds;
    }
}

