/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.internal;

import org.abego.stringgraph.core.Edge;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.internal.NodeImpl;
import org.abego.stringgraph.internal.StringGraphState;
import org.abego.stringgraph.internal.commons.ClassUtil;
import org.abego.stringgraph.internal.commons.EdgeUtil;
import org.abego.stringgraph.internal.commons.StringUtil;
import org.eclipse.jdt.annotation.Nullable;

class EdgeImpl
implements Edge {
    private final int id;
    private final StringGraphState state;

    EdgeImpl(int id, StringGraphState state) {
        this.id = id;
        this.state = state;
    }

    static EdgeImpl asEdgeImpl(@Nullable Edge edge) {
        if (!(edge instanceof EdgeImpl)) {
            throw new IllegalArgumentException("EdgeImpl expected, got " + ClassUtil.className(edge));
        }
        return (EdgeImpl)edge;
    }

    @Override
    public Node getFromNode() {
        return new NodeImpl(this.state.getFromId(this.id), this.state);
    }

    @Override
    public String getLabel() {
        return this.state.getString(this.getLabelId());
    }

    @Override
    public String getLabelText() {
        return StringUtil.quotedIfNeeded(this.getLabel());
    }

    private int getLabelId() {
        return this.state.getLabelId(this.id);
    }

    @Override
    public Node getToNode() {
        return new NodeImpl(this.state.getToId(this.id), this.state);
    }

    @Override
    public String getText() {
        return EdgeUtil.calcEdgeText(this);
    }

    @Override
    public int compareTo(Edge o) {
        return EdgeUtil.getComparator().compare(this, o);
    }

    public String toString() {
        return "EdgeImpl{fromNode=" + StringUtil.quoted2(this.getFromNode().id()) + ", label=" + StringUtil.quoted2(this.getLabel()) + ", toNode=" + StringUtil.quoted2(this.getToNode().id()) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeImpl other = (EdgeImpl)o;
        return this.id == other.id;
    }

    public int hashCode() {
        return this.id;
    }

    int idAsInt() {
        return this.id;
    }
}

