/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.core;

import java.util.Optional;
import java.util.function.Predicate;
import org.abego.stringgraph.core.Edge;
import org.abego.stringgraph.core.EdgeLabels;
import org.abego.stringgraph.core.Edges;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.core.Nodes;
import org.abego.stringgraph.core.Properties;
import org.abego.stringgraph.core.Property;
import org.eclipse.jdt.annotation.Nullable;

public interface StringGraph {
    public boolean hasNode(String var1);

    public Nodes nodes();

    public Nodes nodes(@Nullable String var1, @Nullable String var2, @Nullable String var3);

    public Nodes fromNodes();

    public Nodes toNodes();

    public Nodes nodesFromNode(String var1);

    default public Nodes nodesFrom(Node node) {
        return this.nodesFromNode(node.id());
    }

    public Nodes nodesFromNodeViaEdgeLabeled(String var1, String var2);

    default public Nodes nodesFromNodeViaEdgeLabeled(Node node, String edgeLabel) {
        return this.nodesFromNodeViaEdgeLabeled(node.id(), edgeLabel);
    }

    public Nodes nodesToNode(String var1);

    default public Nodes nodesTo(Node node) {
        return this.nodesToNode(node.id());
    }

    public Nodes nodesViaEdgeLabeledToNode(String var1, String var2);

    default public Nodes nodesViaEdgeLabeledTo(String edgeLabel, Node node) {
        return this.nodesViaEdgeLabeledToNode(edgeLabel, node.id());
    }

    public Edges edges();

    public Edges edges(@Nullable String var1, @Nullable String var2, @Nullable String var3);

    public Edges edgesWith(Predicate<Edge> var1);

    public Edges edgesLabeled(String var1);

    public Edges edgesFromNode(String var1);

    default public Edges edgesFrom(Node node) {
        return this.edgesFromNode(node.id());
    }

    public Edges edgesToNode(String var1);

    default public Edges edgesTo(Node node) {
        return this.edgesToNode(node.id());
    }

    public boolean hasEdge(String var1, String var2, String var3);

    default public boolean hasEdge(Node fromNode, String edgeLabel, Node toNode) {
        return this.hasEdge(fromNode.id(), edgeLabel, toNode.id());
    }

    public EdgeLabels edgeLabels();

    public EdgeLabels edgeLabelsFromNode(String var1);

    default public EdgeLabels edgeLabelsFrom(Node node) {
        return this.edgeLabelsFromNode(node.id());
    }

    public EdgeLabels edgeLabelsToNode(String var1);

    default public EdgeLabels edgeLabelsTo(Node node) {
        return this.edgeLabelsToNode(node.id());
    }

    public Properties getNodeProperties(String var1);

    default public Properties getProperties(Node node) {
        return this.getNodeProperties(node.id());
    }

    public boolean hasNodeProperty(String var1, String var2);

    default public boolean hasProperty(Node node, String propertyName) {
        return this.hasNodeProperty(node.id(), propertyName);
    }

    public Property getNodeProperty(String var1, String var2);

    default public Property getProperty(Node node, String propertyName) {
        return this.getNodeProperty(node.id(), propertyName);
    }

    public String getNodePropertyValue(String var1, String var2);

    default public String getPropertyValue(Node node, String propertyName) {
        return this.getNodePropertyValue(node.id(), propertyName);
    }

    default public boolean getBooleanNodePropertyValue(String node, String propertyName) {
        return this.hasNodeProperty(node, propertyName) && Boolean.parseBoolean(this.getNodePropertyValue(node, propertyName));
    }

    public String getNodePropertyValueOrElse(String var1, String var2, String var3);

    default public String getPropertyValueOrElse(Node node, String propertyName, String defaultValue) {
        return this.getNodePropertyValueOrElse(node.id(), propertyName, defaultValue);
    }

    default public Optional<String> getOptionalNodePropertyValue(String node, String propertyName) {
        if (this.hasNodeProperty(node, propertyName)) {
            return Optional.of(this.getNodePropertyValue(node, propertyName));
        }
        return Optional.empty();
    }
}

