/*
 * Decompiled with CFR 0.152.
 */
package org.abego.stringgraph.core;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.abego.stringgraph.core.Node;
import org.abego.stringgraph.core.exception.ExactlyOneNodeExpectedException;

public interface Nodes
extends Iterable<Node> {
    public int getSize();

    public Stream<Node> stream();

    default public boolean hasSingleNode() {
        return this.getSize() == 1;
    }

    default public Node singleNode() {
        if (!this.hasSingleNode()) {
            throw new ExactlyOneNodeExpectedException(this.getSize());
        }
        return (Node)this.iterator().next();
    }

    default public String singleNodeId() {
        return this.singleNode().id();
    }

    default public Stream<String> idStream() {
        return this.stream().map(Node::id);
    }

    public Nodes intersected(Nodes var1);

    public Nodes union(Nodes var1);

    public Nodes filter(Predicate<Node> var1);
}

