/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.profiling;

import com.opensymphony.xwork2.util.profiling.ProfilingTimerBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UtilTimerStack {
    private static ThreadLocal current = new ThreadLocal();
    public static final String ACTIVATE_PROPERTY = "xwork.profile.activate";
    public static final String MIN_TIME = "atlassian.profile.mintime";
    private static final Log log = LogFactory.getLog(UtilTimerStack.class);

    public static void push(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean newTimer = new ProfilingTimerBean(name);
        newTimer.setStartTime();
        ProfilingTimerBean currentTimer = (ProfilingTimerBean)current.get();
        if (currentTimer != null) {
            currentTimer.addChild(newTimer);
        }
        current.set(newTimer);
    }

    public static void pop(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean currentTimer = (ProfilingTimerBean)current.get();
        if (currentTimer != null && name != null && name.equals(currentTimer.getResource())) {
            currentTimer.setEndTime();
            ProfilingTimerBean parent = currentTimer.getParent();
            if (parent == null) {
                UtilTimerStack.printTimes(currentTimer);
                current.set(null);
            } else {
                current.set(parent);
            }
        } else if (currentTimer != null) {
            UtilTimerStack.printTimes(currentTimer);
            current.set(null);
            log.warn((Object)("Unmatched Timer.  Was expecting " + currentTimer.getResource() + ", instead got " + name));
        }
    }

    private static void printTimes(ProfilingTimerBean currentTimer) {
        log.info((Object)currentTimer.getPrintable(UtilTimerStack.getMinTime()));
    }

    private static long getMinTime() {
        try {
            return Long.parseLong(System.getProperty(MIN_TIME, "0"));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean isActive() {
        return System.getProperty(ACTIVATE_PROPERTY) != null;
    }

    public static void setActive(boolean active) {
        if (active) {
            System.setProperty(ACTIVATE_PROPERTY, "true");
        } else {
            System.setProperty(ACTIVATE_PROPERTY, null);
        }
    }
}

