/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.spring;

import com.opensymphony.xwork2.ObjectFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringObjectFactory
extends ObjectFactory
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(SpringObjectFactory.class);
    protected ApplicationContext appContext;
    protected AutowireCapableBeanFactory autoWiringFactory;
    protected int autowireStrategy = 1;
    private Map classes = new HashMap();
    private boolean useClassCache = true;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
        this.autoWiringFactory = this.findAutoWiringBeanFactory(this.appContext);
    }

    public void setAutowireStrategy(int autowireStrategy) {
        switch (autowireStrategy) {
            case 4: {
                log.info((Object)"Setting autowire strategy to autodetect");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 1: {
                log.info((Object)"Setting autowire strategy to name");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 2: {
                log.info((Object)"Setting autowire strategy to type");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 3: {
                log.info((Object)"Setting autowire strategy to constructor");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid autowire type set");
            }
        }
    }

    public int getAutowireStrategy() {
        return this.autowireStrategy;
    }

    protected AutowireCapableBeanFactory findAutoWiringBeanFactory(ApplicationContext context) {
        if (context instanceof AutowireCapableBeanFactory) {
            return (AutowireCapableBeanFactory)context;
        }
        if (context instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)context).getBeanFactory();
        }
        if (context.getParent() != null) {
            return this.findAutoWiringBeanFactory(context.getParent());
        }
        return null;
    }

    public Object buildBean(String beanName, Map extraContext) throws Exception {
        try {
            return this.appContext.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            Class beanClazz = this.getClassInstance(beanName);
            return this.buildBean(beanClazz, extraContext);
        }
    }

    public Object buildBean(Class clazz, Map extraContext) throws Exception {
        Object bean;
        try {
            bean = this.autoWiringFactory.autowire(clazz, 3, false);
        }
        catch (UnsatisfiedDependencyException e) {
            bean = super.buildBean(clazz, extraContext);
        }
        bean = this.autoWiringFactory.applyBeanPostProcessorsBeforeInitialization(bean, bean.getClass().getName());
        bean = this.autoWiringFactory.applyBeanPostProcessorsAfterInitialization(bean, bean.getClass().getName());
        return this.autoWireBean(bean, this.autoWiringFactory);
    }

    public Object autoWireBean(Object bean) {
        return this.autoWireBean(bean, this.autoWiringFactory);
    }

    public Object autoWireBean(Object bean, AutowireCapableBeanFactory autoWiringFactory) {
        if (autoWiringFactory != null) {
            autoWiringFactory.autowireBeanProperties(bean, this.autowireStrategy, false);
        }
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext(this.appContext);
        }
        return bean;
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        Class<Object> clazz = null;
        if (this.useClassCache) {
            clazz = (Class<?>)this.classes.get(className);
        }
        if (clazz == null) {
            clazz = this.appContext.containsBean(className) ? this.appContext.getBean(className).getClass() : super.getClassInstance(className);
            if (this.useClassCache) {
                this.classes.put(className, clazz);
            }
        }
        return clazz;
    }

    public void initObjectFactory() {
        ObjectFactory.setObjectFactory(this);
    }

    public boolean isNoArgConstructorRequired() {
        return false;
    }

    public void setUseClassCache(boolean useClassCache) {
        this.useClassCache = useClassCache;
    }
}

