/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrefixMethodInvocationUtil {
    private static final Log _log = LogFactory.getLog(PrefixMethodInvocationUtil.class);

    public static void invokePrefixMethod(ActionInvocation actionInvocation, String[] prefixes) throws InvocationTargetException, IllegalAccessException {
        Method method;
        Object action = actionInvocation.getAction();
        String methodName = actionInvocation.getProxy().getMethod();
        if (methodName == null) {
            methodName = "execute";
        }
        if ((method = PrefixMethodInvocationUtil.getPrefixedMethod(prefixes, methodName, action)) != null) {
            method.invoke(action, new Object[0]);
        }
    }

    public static Method getPrefixedMethod(String[] prefixes, String methodName, Object action) {
        assert (prefixes != null);
        String capitalizedMethodName = PrefixMethodInvocationUtil.capitalizeMethodName(methodName);
        for (int a = 0; a < prefixes.length; ++a) {
            String prefixedMethodName = prefixes[a] + capitalizedMethodName;
            try {
                Method method = action.getClass().getMethod(prefixedMethodName, new Class[0]);
                return method;
            }
            catch (NoSuchMethodException e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("cannot find method [" + prefixedMethodName + "] in action [" + action + "]"));
                continue;
            }
        }
        return null;
    }

    public static String capitalizeMethodName(String methodName) {
        assert (methodName != null);
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        return methodName;
    }
}

