/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.TextUtils;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionProxy
implements ActionProxy,
Serializable {
    private static final Log LOG = LogFactory.getLog(DefaultActionProxy.class);
    protected Configuration configuration;
    protected ActionConfig config;
    protected ActionInvocation invocation;
    protected Map extraContext;
    protected String actionName;
    protected String namespace;
    protected String method;
    protected boolean executeResult;
    protected boolean cleanupContext;

    protected DefaultActionProxy(Configuration cfg, String namespace, String actionName, Map extraContext, boolean executeResult, boolean cleanupContext) throws Exception {
        this.cleanupContext = cleanupContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating an DefaultActionProxy for namespace " + namespace + " and action name " + actionName));
        }
        this.configuration = cfg;
        this.actionName = actionName;
        this.namespace = namespace;
        this.executeResult = executeResult;
        this.extraContext = extraContext;
        this.config = this.configuration.getRuntimeConfiguration().getActionConfig(namespace, actionName);
        if (this.config == null) {
            String message = namespace != null && namespace.trim().length() > 0 ? LocalizedTextUtil.findDefaultText("xwork.exception.missing-package-action", Locale.getDefault(), new String[]{namespace, actionName}) : LocalizedTextUtil.findDefaultText("xwork.exception.missing-action", Locale.getDefault(), new String[]{actionName});
            throw new ConfigurationException(message);
        }
        this.prepare();
    }

    public Object getAction() {
        return this.invocation.getAction();
    }

    public String getActionName() {
        return this.actionName;
    }

    public ActionConfig getConfig() {
        return this.config;
    }

    public void setExecuteResult(boolean executeResult) {
        this.executeResult = executeResult;
    }

    public boolean getExecuteResult() {
        return this.executeResult;
    }

    public ActionInvocation getInvocation() {
        return this.invocation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        ActionContext nestedContext = ActionContext.getContext();
        ActionContext.setContext(this.invocation.getInvocationContext());
        String retCode = null;
        try {
            retCode = this.invocation.invoke();
        }
        finally {
            if (this.cleanupContext) {
                ActionContext.setContext(nestedContext);
            }
        }
        return retCode;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
        this.resolveMethod();
    }

    private void resolveMethod() {
        if (!TextUtils.stringSet(this.method)) {
            this.method = this.config.getMethodName();
            if (!TextUtils.stringSet(this.method)) {
                this.method = "execute";
            }
        }
    }

    protected void prepare() throws Exception {
        this.invocation = ActionProxyFactory.getFactory().createActionInvocation(this, this.extraContext);
        this.resolveMethod();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

