/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jmx.jboss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.ee.jmx.jboss.QuartzServiceMBean;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzService
extends ServiceMBeanSupport
implements QuartzServiceMBean {
    private Properties properties = new Properties();
    private StdSchedulerFactory schedulerFactory;
    private String jndiName = "Quartz";
    private String propertiesFile = "";
    private boolean error = false;
    private boolean useProperties = false;
    private boolean usePropertiesFile = false;

    public void setJndiName(String jndiName) throws Exception {
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            this.unbind(oldName);
            try {
                this.rebind();
            }
            catch (NamingException ne) {
                this.log.error((Object)this.captureStackTrace(ne));
                throw new SchedulerConfigException("Failed to rebind Scheduler - ", (Exception)ne);
            }
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getName() {
        return "QuartzService(" + this.jndiName + ")";
    }

    public void setProperties(String properties) {
        if (this.usePropertiesFile) {
            this.log.error((Object)"Must specify only one of 'Properties' or 'PropertiesFile'");
            this.error = true;
            return;
        }
        this.useProperties = true;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(properties.getBytes());
            this.properties = new Properties();
            this.properties.load(bais);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getProperties() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.properties.store(baos, "");
            return new String(baos.toByteArray());
        }
        catch (IOException ioe) {
            return "";
        }
    }

    public void setPropertiesFile(String propertiesFile) {
        if (this.useProperties) {
            this.log.error((Object)"Must specify only one of 'Properties' or 'PropertiesFile'");
            this.error = true;
            return;
        }
        this.usePropertiesFile = true;
        this.propertiesFile = propertiesFile;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void createService() throws Exception {
        this.log.info((Object)("Create QuartzService(" + this.jndiName + ")..."));
        if (this.error) {
            this.log.error((Object)"Must specify only one of 'Properties' or 'PropertiesFile'");
            throw new Exception("Must specify only one of 'Properties' or 'PropertiesFile'");
        }
        this.schedulerFactory = new StdSchedulerFactory();
        try {
            if (this.useProperties) {
                this.schedulerFactory.initialize(this.properties);
            }
            if (this.usePropertiesFile) {
                this.schedulerFactory.initialize(this.propertiesFile);
            }
        }
        catch (Exception e) {
            this.log.error((Object)this.captureStackTrace(e));
            throw new SchedulerConfigException("Failed to initialize Scheduler - ", e);
        }
        this.log.info((Object)("QuartzService(" + this.jndiName + ") created."));
    }

    public void destroyService() throws Exception {
        this.log.info((Object)("Destroy QuartzService(" + this.jndiName + ")..."));
        this.schedulerFactory = null;
        this.log.info((Object)("QuartzService(" + this.jndiName + ") destroyed."));
    }

    public void startService() throws Exception {
        this.log.info((Object)("Start QuartzService(" + this.jndiName + ")..."));
        try {
            this.rebind();
        }
        catch (NamingException ne) {
            this.log.error((Object)this.captureStackTrace(ne));
            throw new SchedulerConfigException("Failed to rebind Scheduler - ", (Exception)ne);
        }
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.start();
        }
        catch (Exception e) {
            this.log.error((Object)this.captureStackTrace(e));
            throw new SchedulerConfigException("Failed to start Scheduler - ", e);
        }
        this.log.info((Object)("QuartzService(" + this.jndiName + ") started."));
    }

    public void stopService() throws Exception {
        this.log.info((Object)("Stop QuartzService(" + this.jndiName + ")..."));
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.shutdown();
        }
        catch (Exception e) {
            this.log.error((Object)this.captureStackTrace(e));
            throw new SchedulerConfigException("Failed to shutdown Scheduler - ");
        }
        this.unbind(this.jndiName);
        this.log.info((Object)("QuartzService(" + this.jndiName + ") stopped."));
    }

    private String captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    private void rebind() throws Exception {
        InitialContext rootCtx = new InitialContext();
        Name fullName = rootCtx.getNameParser("").parse(this.jndiName);
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        NonSerializableFactory.rebind((Name)fullName, (Object)scheduler, (boolean)true);
    }

    private void unbind(String jndiName) {
        try {
            InitialContext rootCtx = new InitialContext();
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)jndiName);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

