/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.Verifiable;
import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.MethodExpectation;
import com.mockobjects.dynamic.MethodMap;
import com.mockobjects.dynamic.MockCall;
import com.mockobjects.dynamic.MockReturnCall;
import com.mockobjects.dynamic.MockThrowCall;
import com.mockobjects.dynamic.MockVoidCall;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;

public class Mock
extends Assert
implements InvocationHandler,
Verifiable {
    public static final Object VOID = new Object();
    public static final Constraint[] NO_ARGS = new Constraint[0];
    private Class[] _proxy_classes;
    private Object _proxy;
    private MethodMap methods = new MethodMap();
    private boolean _strict = false;
    private Map _default_results = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public Mock(Class interface_to_mock) {
        this(new Class[]{interface_to_mock});
    }

    public Mock(Class interface1, Class interface2) {
        this(new Class[]{interface1, interface2});
    }

    public Mock(Class interface1, Class interface2, Class interface3) {
        this(new Class[]{interface1, interface2, interface3});
    }

    public Mock(Class interface1, Class interface2, Class interface3, Class interface4) {
        this(new Class[]{interface1, interface2, interface3, interface4});
    }

    public Mock(Class[] interfaces_to_mock) {
        this._proxy_classes = (Class[])interfaces_to_mock.clone();
        this._proxy = this.createInterface(interfaces_to_mock);
        this.setupDefaultResult(Byte.TYPE, new Byte(0));
        this.setupDefaultResult(Short.TYPE, new Short(0));
        this.setupDefaultResult(Integer.TYPE, new Integer(0));
        this.setupDefaultResult(Long.TYPE, new Long(0L));
        this.setupDefaultResult(Float.TYPE, new Float(0.0f));
        this.setupDefaultResult(Double.TYPE, new Double(0.0));
        this.setupDefaultResult(Boolean.TYPE, Boolean.FALSE);
        this.setupDefaultResult(Character.TYPE, new Character('\u0000'));
        this.setupDefaultResult(class$java$lang$String == null ? (class$java$lang$String = Mock.class$("java.lang.String")) : class$java$lang$String, "");
    }

    public Object proxy() {
        return this._proxy;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public void setup(String method_name, MockCall call) {
        this.checkMethodName(method_name);
        this.methods.setupCall(method_name, call);
    }

    public void setupResult(String method_name, Object result) {
        this.setup(method_name, new MockReturnCall(result));
    }

    public void setupThrow(String method_name, Throwable exception) {
        this.setup(method_name, new MockThrowCall(exception));
    }

    public void setupDefaultResult(Class result_type, Object result_value) {
        this._default_results.put(result_type, result_value);
    }

    public void expect(String method_name, MockCall call) {
        this.checkMethodName(method_name);
        this.methods.expectCall(method_name, call);
    }

    public void expectAndReturn(String method, Constraint[] args, Object result) {
        this.expect(method, new MockReturnCall(args, result));
    }

    public void expectAndReturn(String method, Object arg, Object result) {
        this.expectAndReturn(method, C.args(C.eq(arg)), result);
    }

    public void expectAndReturn(String method, Object result) {
        this.expectAndReturn(method, NO_ARGS, result);
    }

    public void expectVoid(String method, Constraint[] args) {
        this.expect(method, new MockVoidCall(args));
    }

    public void expectVoid(String method, Object arg) {
        this.expectVoid(method, C.args(C.eq(arg)));
    }

    public void expectVoid(String method) {
        this.expectVoid(method, NO_ARGS);
    }

    public void expectAndThrow(String method, Constraint[] args, Throwable exception) {
        this.expect(method, new MockThrowCall(args, exception));
    }

    public void expectAndThrow(String method, Object arg, Throwable exception) {
        this.expectAndThrow(method, C.args(C.eq(arg)), exception);
    }

    public void expectAndThrow(String method, Throwable exception) {
        this.expectAndThrow(method, NO_ARGS, exception);
    }

    public void expectNotCalled(String method_name) {
        this.checkMethodName(method_name);
        this.methods.expectNotCalled(method_name);
    }

    public void order(String preceding_method, String subsequent_method) {
        this.checkMethodName(preceding_method);
        this.checkMethodName(subsequent_method);
        this.methods.order(preceding_method, subsequent_method);
    }

    public boolean equals(Object obj) {
        try {
            return this.equals(Proxy.getInvocationHandler(obj));
        }
        catch (IllegalArgumentException notAProxy) {
            return super.equals(obj);
        }
    }

    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        MethodExpectation expectation = this.methods.startCall(method.getName());
        try {
            return this.getMatchingMethod(method).invoke((Object)this, args);
        }
        catch (NoSuchMethodException ex) {
            return this.mockCall(expectation, method, args);
        }
    }

    protected Object mockCall(Method method, Object[] args) throws Throwable {
        return this.mockCall(this.methods.startCall(method.getName()), method, args);
    }

    protected Object mockCall(MethodExpectation expectation, Method method, Object[] args) throws Throwable {
        if (expectation.canBeCalled()) {
            return expectation.callAndCheckResult(method, args);
        }
        Assert.assertTrue((String)("unexpected call to " + method.getName()), (!this._strict ? 1 : 0) != 0);
        return this.defaultResult(method.getReturnType());
    }

    private Method getMatchingMethod(Method method) throws NoSuchMethodException {
        return this.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    private Object defaultResult(Class return_type) {
        return this._default_results.get(return_type);
    }

    public void verify() {
        this.methods.verify();
    }

    private Object createInterface(Class[] interface_classes) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), interface_classes, (InvocationHandler)this);
    }

    private void checkMethodName(String method_name) {
        int i = 0;
        while (i < this._proxy_classes.length) {
            if (this.hasMethod(this._proxy_classes[i], method_name)) {
                return;
            }
            ++i;
        }
        Assert.fail((String)("method " + method_name + " is not defined by any of the mocked interfaces"));
    }

    private boolean hasMethod(Class c, String method_name) {
        Method[] methods = c.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(method_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

