/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.ExpectationValue;
import com.mockobjects.Verifiable;
import com.mockobjects.dynamic.MethodMap;
import com.mockobjects.dynamic.Mock;
import com.mockobjects.dynamic.MockCall;
import java.lang.reflect.Method;
import junit.framework.Assert;

public class MethodExpectation
implements Verifiable {
    public final String name;
    private ExpectationValue wasCalled;
    private MockCall mockCall;
    private MethodMap prerequisites = new MethodMap();

    public MethodExpectation(String aName) {
        this.name = aName;
        this.initializeWasCalled();
    }

    public void expectCall(MockCall aCall) {
        this.mockCall = aCall;
        this.wasCalled.setExpected("was called");
    }

    public void setupCall(MockCall aCall) {
        this.mockCall = aCall;
        this.initializeWasCalled();
    }

    public void expectNotCalled() {
        this.wasCalled.setExpectNothing();
    }

    public void shouldCallBefore(MethodExpectation laterMethod) {
        laterMethod.prerequisites.put(this);
    }

    public boolean canBeCalled() {
        return this.mockCall != null;
    }

    public Object callAndCheckResult(Method method, Object[] args) throws Throwable {
        Object result = this.mockCall.call(args);
        this.checkResultType(method, result);
        return result;
    }

    public void startCall() {
        this.wasCalled.setActual("was called");
        this.prerequisites.verify();
    }

    public void verify() {
        this.wasCalled.verify();
    }

    private void initializeWasCalled() {
        this.wasCalled = new ExpectationValue(this.name);
    }

    private void checkResultType(Method method, Object result) {
        if (method.getReturnType() == Void.TYPE) {
            Assert.assertTrue((String)("trying to return " + result + " from void method " + method.getName()), (result == Mock.VOID ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("returning nothing from non-void method " + method.getName()), (result != Mock.VOID ? 1 : 0) != 0);
        }
    }
}

