/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.sql.factory;

import me.wuwenbin.sql.exception.DeleteSQLConditionsNullException;
import me.wuwenbin.sql.exception.InsertColumnNullException;
import me.wuwenbin.sql.exception.TableNameNullException;
import me.wuwenbin.sql.exception.UpdateColumnNullException;
import me.wuwenbin.sql.util.SQLBuilderUtils;

public class SQLStrBuilder {
    private final String SPACE = " ";
    private final String FROM = " FROM ";
    private final String AND = " AND ";
    private final String OR = " OR ";
    private final String WHERE = " WHERE ";
    private final String selectPre = "SELECT ";
    private final String insertPre = "INSERT INTO ";
    private final String updatePre = "UPDATE ";
    private final String deletePre = "DELETE FROM ";

    public String countAll(String tableName) throws TableNameNullException {
        return this.countAndByColumns(tableName, new String[0]);
    }

    public String countAndByColumns(String tableName, String ... columns) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append(" WHERE ").append("1=1");
            for (String column : columns) {
                sb.append(" AND ").append(column).append(" = ?");
            }
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String countOrByColumns(String tableName, String ... columns) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append(" WHERE ").append("1<>1");
            for (String column : columns) {
                sb.append(" OR ").append(column).append(" = ?");
            }
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectPartByColumnsAnd(String tableName, String[] selectColumns, String ... conditionColumns) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        if (selectColumns != null && selectColumns.length > 0) {
            for (int i = 0; i < selectColumns.length; ++i) {
                String selectColumn = selectColumns[i];
                sb.append(tableName).append(".").append(selectColumn).append(", ");
            }
        } else {
            sb.append(tableName).append(".* ");
        }
        sb.append(" FROM ").append(tableName);
        this.assembleConditionSQL(tableName, sb, conditionColumns);
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectAllByColumns(String tableName, String ... columns) throws TableNameNullException {
        return this.selectPartByColumnsAnd(tableName, null, columns);
    }

    public String selectAll(String tableName) throws TableNameNullException {
        return this.selectAllByColumns(tableName, null);
    }

    public String insertAll(String tableName, int columnCount) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableName).append(" VALUES(");
        columnCount = columnCount <= 0 ? 1 : columnCount;
        for (int i = 0; i < columnCount; ++i) {
            sb.append("?, ");
        }
        sb.append(")");
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String insertColumns(String tableName, String ... columns) throws TableNameNullException, InsertColumnNullException {
        StringBuilder values;
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append("(");
            values = new StringBuilder("(");
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                sb.append(column).append(", ");
                values.append("?, ");
            }
        } else {
            throw new InsertColumnNullException();
        }
        sb.append(") ").append(" VALUES").append((CharSequence)values).append(")");
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String updateColumnsByColumnArray(String tableName, String[] updateColumns, String[] conditionColumns) throws TableNameNullException, UpdateColumnNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("UPDATE ");
        sb.append(tableName);
        if (updateColumns != null && updateColumns.length > 0) {
            sb.append(" SET ");
            for (String updateColumn : updateColumns) {
                sb.append(updateColumn).append(" = ?, ");
            }
        } else {
            throw new UpdateColumnNullException();
        }
        if (conditionColumns != null && conditionColumns.length > 0) {
            sb.append(" WHERE ");
            for (String conditionColumn : conditionColumns) {
                sb.append(conditionColumn).append(" = ?").append(" AND ");
            }
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String deleteByColumns(String tableName, String ... columns) throws TableNameNullException, DeleteSQLConditionsNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        sb.append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append(" WHERE ");
            for (String column : columns) {
                sb.append(column).append(" = ?").append(" AND ");
            }
        } else {
            throw new DeleteSQLConditionsNullException();
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    private void assembleConditionSQL(String tableName, StringBuilder sb, String[] column) {
        if (column != null && column.length > 0) {
            sb.append(" WHERE ").append("1=1");
            for (int i = 0; i < column.length; ++i) {
                String conditionColumn = column[i];
                sb.append(" AND ").append(tableName).append(".").append(conditionColumn).append(" = ?");
            }
        }
    }
}

